/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.block.Centrifuge;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.container.ManualSlotItemHandler;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.tileentity.CentrifugeTileEntity;
import cy.jdkdigital.productivebees.tileentity.InventoryHandlerHelper;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CentrifugeContainer
extends AbstractContainer {
    public final CentrifugeTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;

    public CentrifugeContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, CentrifugeContainer.getTileEntity(playerInventory, data));
    }

    public CentrifugeContainer(int windowId, PlayerInventory playerInventory, final CentrifugeTileEntity tileEntity) {
        super((ContainerType)ModContainerTypes.CENTRIFUGE.get(), windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return (Integer)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(fluidHandler -> fluidHandler.getFluidInTank(0).getAmount()).orElse((Object)0);
            }

            public void func_221494_a(int value) {
                tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                    FluidStack fluid = fluidHandler.getFluidInTank(0);
                    if (fluid.isEmpty()) {
                        fluidHandler.fill(new FluidStack((Fluid)ModFluids.HONEY.get(), value), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        fluid.setAmount(value);
                    }
                });
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return tileEntity.recipeProgress;
            }

            public void func_221494_a(int value) {
                tileEntity.recipeProgress = value;
            }
        });
        InvWrapper inventory = new InvWrapper((IInventory)playerInventory);
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 0, 152, 17));
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 1, 26, 35));
            this.addSlotBox((IItemHandler)inv, InventoryHandlerHelper.OUTPUT_SLOTS[0], 80, 17, 3, 18, 3, 18);
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 11, 152, 53));
        });
        this.layoutPlayerInventorySlots((IItemHandler)inventory, 0, 8, 84);
    }

    private static CentrifugeTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof CentrifugeTileEntity) {
            return (CentrifugeTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return (Boolean)this.canInteractWithCallable.func_221485_a((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof Centrifuge && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }
}

