/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.tileentity.DragonEggHiveTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class AdvancedBeehiveScreen
extends ContainerScreen<AdvancedBeehiveContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive.png");
    private static final ResourceLocation GUI_TEXTURE_EXPANDED = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive_expanded.png");
    private static final ResourceLocation GUI_TEXTURE_BEE_OVERLAY = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive_bee_overlay.png");
    private static HashMap<String, ResourceLocation> beeTextureLocations = new HashMap();
    private static HashMap<String, ITextComponent> stringCache = new HashMap();

    public AdvancedBeehiveScreen(AdvancedBeehiveContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        HashMap<Integer, List<Integer>> positions;
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        assert (this.minecraft != null);
        boolean expanded = (Boolean)((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b((IProperty)AdvancedBeehive.EXPANDED);
        HashMap<Integer, List<Integer>> hashMap = positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        if (((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.inhabitantList.size() > 0) {
            int i = 0;
            for (String beeId : ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.inhabitantList) {
                if (positions.get(i) == null || beeId.isEmpty()) continue;
                ResourceLocation beeTexture = AdvancedBeehiveScreen.getBeeTexture(beeId, ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_145831_w());
                this.minecraft.func_110434_K().func_110577_a(beeTexture);
                AdvancedBeehiveScreen.blit((int)positions.get(i).get(0), (int)positions.get(i).get(1), (float)20.0f, (float)20.0f, (int)14, (int)14, (int)128, (int)128);
                this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE_BEE_OVERLAY);
                AdvancedBeehiveScreen.blit((int)positions.get(i).get(0), (int)positions.get(i).get(1), (float)0.0f, (float)0.0f, (int)14, (int)14, (int)14, (int)14);
                ++i;
            }
            int j = 0;
            for (final String beeId : ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.inhabitantList) {
                if (this.func_195359_a(positions.get(j).get(0), positions.get(j).get(1), 16, 16, mouseX, mouseY) && stringCache.containsKey(beeId)) {
                    ArrayList<String> tooltipList = new ArrayList<String>(){
                        {
                            this.add(((ITextComponent)stringCache.get(beeId)).func_150254_d());
                        }
                    };
                    tooltipList.add(stringCache.get(beeId + "_mod").func_211708_a(TextFormatting.ITALIC).func_211708_a(TextFormatting.BLUE).func_150254_d());
                    this.renderTooltip(tooltipList, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                }
                ++j;
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean expanded = (Boolean)((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b((IProperty)AdvancedBeehive.EXPANDED);
        int honeyLevel = (Integer)((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(expanded ? GUI_TEXTURE_EXPANDED : GUI_TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int yOffset = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity instanceof DragonEggHiveTileEntity ? 17 : 0;
        int progress = honeyLevel == 0 ? 0 : 5 * honeyLevel;
        this.blit(this.field_147003_i + 82, this.field_147009_r + 35, 176, 14 + yOffset, progress, 16);
    }

    public static ResourceLocation getBeeTexture(@Nonnull ResourceLocation res, World world) {
        String beeId = res.toString();
        if (beeTextureLocations.get(beeId) != null) {
            return beeTextureLocations.get(beeId);
        }
        Entity bee = ((EntityType)ForgeRegistries.ENTITIES.getValue(res)).func_200721_a(world);
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer renderer = manager.func_78713_a(bee);
        ResourceLocation resource = renderer.func_110775_a(bee);
        beeTextureLocations.put(beeId, resource);
        stringCache.put(beeId, bee.func_145748_c_());
        String modId = resource.func_110624_b();
        String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
        if (modId.equals("minecraft")) {
            modName = "Minecraft";
        }
        stringCache.put(beeId + "_mod", (ITextComponent)new StringTextComponent(modName));
        return beeTextureLocations.get(beeId);
    }

    public static ResourceLocation getBeeTexture(String beeId, World world) {
        ResourceLocation resLocation = new ResourceLocation(beeId);
        return AdvancedBeehiveScreen.getBeeTexture(resLocation, world);
    }
}

