/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.entity.bee.IBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.SolitaryBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.hive.EnderBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.GlowingBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.MagmaticBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.QuartzBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.SlimyBeeEntity;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeEffect;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class ProductiveBeeEntity
extends BeeEntity
implements IBeeEntity {
    protected Map<BeeAttribute<?>, Object> beeAttributes = new HashMap();
    protected Predicate<PointOfInterestType> beehiveInterests = poiType -> poiType == PointOfInterestType.field_226356_s_ || poiType == ModPointOfInterestTypes.SOLITARY_HIVE.get() || poiType == ModPointOfInterestTypes.SOLITARY_NEST.get();

    public ProductiveBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.beeAttributes.put(BeeAttributes.PRODUCTIVITY, world.field_73012_v.nextInt(2));
        this.beeAttributes.put(BeeAttributes.TEMPER, 1);
        this.beeAttributes.put(BeeAttributes.ENDURANCE, 1);
        this.beeAttributes.put(BeeAttributes.BEHAVIOR, 0);
        this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        this.beeAttributes.put(BeeAttributes.TYPE, "hive");
        this.beeAttributes.put(BeeAttributes.FOOD_SOURCE, BlockTags.field_226149_I_);
        this.beeAttributes.put(BeeAttributes.APHRODISIACS, ItemTags.field_226159_I_);
        this.beeAttributes.put(BeeAttributes.NESTING_PREFERENCE, BlockTags.field_226151_aa_);
        this.beeAttributes.put(BeeAttributes.EFFECTS, new BeeEffect(new HashMap<Effect, Integer>()));
        this.field_70714_bg.func_75776_a(3, (Goal)new ProductiveTemptGoal((CreatureEntity)this, 1.25));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BeeEntity.StingGoal((BeeEntity)this, (CreatureEntity)this, (double)1.4f, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new BeeEntity.EnterBeehiveGoal((BeeEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, ProductiveBeeEntity.class));
        this.field_226370_bJ_ = new PollinateGoal();
        this.field_70714_bg.func_75776_a(4, (Goal)this.field_226370_bJ_);
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new UpdateNestGoal());
        this.field_226371_bK_ = new FindNestGoal();
        this.field_70714_bg.func_75776_a(5, (Goal)this.field_226371_bK_);
        this.field_226372_bL_ = new BeeEntity.FindFlowerGoal((BeeEntity)this);
        this.field_70714_bg.func_75776_a(6, (Goal)this.field_226372_bL_);
        this.field_70714_bg.func_75776_a(7, (Goal)new BeeEntity.FindPollinationTargetGoal((BeeEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new BeeEntity.WanderGoal((BeeEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new BeeEntity.AngerGoal((BeeEntity)this, (BeeEntity)this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new BeeEntity.AttackPlayerGoal((BeeEntity)this));
    }

    public void func_70636_d() {
        List players;
        BeeEffect effect;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.effectTicks.get() == 0 && (effect = this.getAttributeValue(BeeAttributes.EFFECTS)).getEffects().size() > 0 && (players = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(new BlockPos((Entity)this)).func_72314_b(8.0, 6.0, 8.0))).size() > 0) {
            players.forEach(playerEntity -> effect.getEffects().forEach((potionEffect, duration) -> playerEntity.func_195064_c(new EffectInstance(potionEffect, duration.intValue()))));
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.leashedTicks.get() == 0 && this.func_110167_bD()) {
            boolean isInDanger;
            int behavior;
            int tolerance = this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE);
            if (tolerance < 2 && (double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.toleranceChance.get() && (tolerance < 1 && this.field_70170_p.func_72896_J() || this.field_70170_p.func_72911_I())) {
                this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, tolerance + 1);
            }
            if ((behavior = this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue()) < 2 && (double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.behaviorChance.get()) {
                if (behavior < 1 && this.field_70170_p.func_226690_K_()) {
                    this.beeAttributes.put(BeeAttributes.BEHAVIOR, this.field_70170_p.field_73012_v.nextFloat() < 0.85f ? 1 : 2);
                } else if (behavior == 1 && !this.field_70170_p.func_226690_K_()) {
                    this.beeAttributes.put(BeeAttributes.BEHAVIOR, this.field_70170_p.field_73012_v.nextFloat() < 0.85f ? 2 : 0);
                }
            }
            boolean bl = isInDanger = tolerance < 1 && this.field_70170_p.func_72896_J() || behavior < 1 && this.field_70170_p.func_226690_K_();
            if (isInDanger && (double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.damageChance.get()) {
                this.func_70606_j(this.func_110143_aJ() - this.func_110138_aP() / 3.0f - 1.0f);
            }
        }
    }

    public boolean func_226427_ez_() {
        return super.func_226427_ez_() && this.getAttributeValue(BeeAttributes.TEMPER) > 0;
    }

    public boolean func_226439_k_(BlockPos pos) {
        return this.field_70170_p.func_195588_v(pos) && this.field_70170_p.func_180495_p(pos).func_177230_c().func_203417_a(this.getAttributeValue(BeeAttributes.FOOD_SOURCE));
    }

    public boolean func_226422_eP_() {
        if (!this.func_226409_eA_()) {
            return false;
        }
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.field_226369_bI_);
        return tileentity instanceof BeehiveTileEntity;
    }

    public boolean func_226415_eI_() {
        if (this.field_226364_bD_ <= 0 && !this.field_226370_bJ_.func_226503_k_() && !this.func_226412_eE_()) {
            boolean shouldReturnToHive = this.func_226414_eH_() || this.func_226411_eD_() || this.field_70170_p.func_226690_K_() && !this.canOperateDuringNight() || this.field_70170_p.func_72896_J() && !this.canOperateDuringRain();
            return shouldReturnToHive && !this.func_226417_eK_();
        }
        return false;
    }

    public String getBeeType() {
        return this.func_70022_Q().split("[:]")[1].replace("_bee", "");
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b().func_206844_a(this.getAttributeValue(BeeAttributes.APHRODISIACS));
    }

    public <T> T getAttributeValue(BeeAttribute<T> parameter) {
        return (T)this.beeAttributes.get(parameter);
    }

    public Map<BeeAttribute<?>, Object> getBeeAttributes() {
        return this.beeAttributes;
    }

    public boolean canOperateDuringNight() {
        return this.getAttributeValue(BeeAttributes.BEHAVIOR) > 0;
    }

    boolean canOperateDuringRain() {
        return this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE) == 1;
    }

    boolean canOperateDuringThunder() {
        return this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE) == 2;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("bee_productivity", this.getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue());
        tag.func_74768_a("bee_endurance", this.getAttributeValue(BeeAttributes.ENDURANCE).intValue());
        tag.func_74768_a("bee_temper", this.getAttributeValue(BeeAttributes.TEMPER).intValue());
        tag.func_74768_a("bee_behavior", this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue());
        tag.func_74768_a("bee_weather_tolerance", this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE).intValue());
        tag.func_74778_a("bee_type", this.getAttributeValue(BeeAttributes.TYPE));
        tag.func_74778_a("bee_food_source", this.getAttributeValue(BeeAttributes.FOOD_SOURCE).func_199886_b().toString());
        tag.func_74778_a("bee_aphrodisiac", this.getAttributeValue(BeeAttributes.APHRODISIACS).func_199886_b().toString());
        tag.func_74778_a("bee_nesting_preference", this.getAttributeValue(BeeAttributes.NESTING_PREFERENCE).func_199886_b().toString());
        tag.func_218657_a("bee_effects", (INBT)this.getAttributeValue(BeeAttributes.EFFECTS).serializeNBT());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("bee_productivity")) {
            this.beeAttributes.clear();
            this.beeAttributes.put(BeeAttributes.PRODUCTIVITY, tag.func_74762_e("bee_productivity"));
            this.beeAttributes.put(BeeAttributes.ENDURANCE, tag.func_74764_b("bee_endurance") ? tag.func_74762_e("bee_endurance") : 1);
            this.beeAttributes.put(BeeAttributes.TEMPER, tag.func_74762_e("bee_temper"));
            this.beeAttributes.put(BeeAttributes.BEHAVIOR, tag.func_74762_e("bee_behavior"));
            this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, tag.func_74762_e("bee_weather_tolerance"));
            this.beeAttributes.put(BeeAttributes.TYPE, tag.func_74779_i("bee_type"));
            this.beeAttributes.put(BeeAttributes.FOOD_SOURCE, new BlockTags.Wrapper(new ResourceLocation(tag.func_74779_i("bee_food_source"))));
            this.beeAttributes.put(BeeAttributes.APHRODISIACS, new ItemTags.Wrapper(new ResourceLocation(tag.func_74779_i("bee_aphrodisiac"))));
            if (tag.func_74764_b("bee_nesting_preference") && !tag.func_74779_i("bee_nesting_preference").equals("")) {
                this.beeAttributes.put(BeeAttributes.NESTING_PREFERENCE, BlockTags.func_199896_a().func_199915_b(new ResourceLocation(tag.func_74779_i("bee_nesting_preference"))));
            } else {
                this.beeAttributes.put(BeeAttributes.NESTING_PREFERENCE, this instanceof SlimyBeeEntity ? ModTags.SLIMY_NESTS : (this instanceof EnderBeeEntity ? ModTags.END_NESTS : (this instanceof GlowingBeeEntity ? ModTags.GLOWSTONE_NESTS : (this instanceof MagmaticBeeEntity ? ModTags.NETHER_BRICK_NESTS : (this instanceof QuartzBeeEntity ? ModTags.NETHER_QUARTZ_NESTS : (this instanceof SolitaryBeeEntity ? ModTags.SOLITARY_OVERWORLD_NESTS : BlockTags.field_226151_aa_))))));
            }
            if (tag.func_74764_b("bee_effects")) {
                this.beeAttributes.put(BeeAttributes.EFFECTS, new BeeEffect((CompoundNBT)tag.func_74781_a("bee_effects")));
            } else {
                this.beeAttributes.put(BeeAttributes.EFFECTS, new BeeEffect(new HashMap<Effect, Integer>()));
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_" + this.getBeeType() + "_bee"));
        return new ItemStack((IItemProvider)item);
    }

    public BeeEntity func_90011_a(AgeableEntity targetEntity) {
        BeeEntity newBee;
        ResourceLocation breedingResult = BeeHelper.getBreedingResult(this, targetEntity, this.field_70170_p);
        if (breedingResult == null) {
            breedingResult = new ResourceLocation(this.getBeeType());
        }
        if ((newBee = (BeeEntity)((EntityType)ForgeRegistries.ENTITIES.getValue(breedingResult)).func_200721_a(this.field_70170_p)) instanceof ProductiveBeeEntity) {
            BeeHelper.setOffspringAttributes((ProductiveBeeEntity)newBee, this, targetEntity);
        }
        return newBee;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof BeeEntity)) {
            return false;
        }
        ResourceLocation breedingResult = BeeHelper.getBreedingResult(this, (AgeableEntity)otherAnimal, this.field_70170_p);
        return breedingResult != null && this.func_70880_s() && otherAnimal.func_70880_s();
    }

    public static Double getProductionChance(String beeId, double defValue) {
        if (ProductiveBeesConfig.BEES.itemProductionRates.containsKey(beeId)) {
            return ProductiveBeeEntity.getProductionChance(beeId);
        }
        return defValue;
    }

    public static Double getProductionChance(String beeId) {
        return (Double)ProductiveBeesConfig.BEES.itemProductionRates.get(beeId).get();
    }

    public class ProductiveTemptGoal
    extends TemptGoal {
        public ProductiveTemptGoal(CreatureEntity entity, double speed) {
            super(entity, speed, false, Ingredient.func_199805_a(ProductiveBeeEntity.this.getAttributeValue(BeeAttributes.APHRODISIACS)));
        }
    }

    class UpdateNestGoal
    extends BeeEntity.UpdateBeehiveGoal {
        private UpdateNestGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
        }

        public void func_75249_e() {
            ProductiveBeeEntity.this.field_226366_bF_ = 200;
            List<BlockPos> nearbyNests = this.getNearbyFreeNests();
            if (!nearbyNests.isEmpty()) {
                BlockPos blockPos;
                Iterator<BlockPos> iterator = nearbyNests.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    ProductiveBeeEntity.this.field_226371_bK_.func_226477_j_();
                    ProductiveBeeEntity.this.field_226369_bI_ = nearbyNests.get(0);
                    return;
                } while (ProductiveBeeEntity.this.field_226371_bK_.func_226473_b_(blockPos = iterator.next()));
                ProductiveBeeEntity.this.field_226369_bI_ = blockPos;
            }
        }

        private List<BlockPos> getNearbyFreeNests() {
            BlockPos pos = new BlockPos((Entity)ProductiveBeeEntity.this);
            PointOfInterestManager poiManager = ((ServerWorld)ProductiveBeeEntity.this.field_70170_p).func_217443_B();
            Stream stream = poiManager.func_219146_b(ProductiveBeeEntity.this.beehiveInterests, pos, 30, PointOfInterestManager.Status.ANY);
            return stream.map(PointOfInterest::func_218261_f).filter(arg_0 -> ((ProductiveBeeEntity)ProductiveBeeEntity.this).func_226435_i_(arg_0)).sorted(Comparator.comparingDouble(vec -> vec.func_177951_i((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    public class FindNestGoal
    extends BeeEntity.FindBeehiveGoal {
        public FindNestGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
        }

        public boolean func_225506_g_() {
            if (!ProductiveBeeEntity.this.func_226409_eA_()) {
                return false;
            }
            Tag<Block> nestTag = ProductiveBeeEntity.this.getAttributeValue(BeeAttributes.NESTING_PREFERENCE);
            if (nestTag == null || nestTag.func_199885_a().size() == 0) {
                return false;
            }
            return !ProductiveBeeEntity.this.func_213394_dL() && ProductiveBeeEntity.this.func_226415_eI_() && !this.isCloseEnough(ProductiveBeeEntity.this.field_226369_bI_) && ProductiveBeeEntity.this.field_70170_p.func_180495_p(ProductiveBeeEntity.this.field_226369_bI_).func_203425_a(nestTag);
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (ProductiveBeeEntity.this.func_226401_b_(pos, 2)) {
                return true;
            }
            Path path = ProductiveBeeEntity.this.field_70699_by.func_75505_d();
            return path != null && path.func_224770_k().equals((Object)pos) && path.func_224771_h() && path.func_75879_b();
        }

        protected void func_226475_c_(BlockPos pos) {
            this.field_226469_d_.add(pos);
            TileEntity tileEntity = ProductiveBeeEntity.this.field_70170_p.func_175625_s(pos);
            int maxBees = 3;
            if (tileEntity instanceof AdvancedBeehiveTileEntityAbstract) {
                maxBees = ((AdvancedBeehiveTileEntityAbstract)tileEntity).MAX_BEES;
            }
            while (this.field_226469_d_.size() > maxBees) {
                this.field_226469_d_.remove(0);
            }
        }
    }

    public class PollinateGoal
    extends BeeEntity.PollinateGoal {
        public PollinateGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
            this.field_226492_c_ = blockState -> {
                Tag<Block> interests = ProductiveBeeEntity.this.getAttributeValue(BeeAttributes.FOOD_SOURCE);
                boolean isInterested = blockState.func_203425_a(interests);
                if (isInterested && blockState.func_203425_a(BlockTags.field_226148_H_)) {
                    if (blockState.func_177230_c() == Blocks.field_196800_gd) {
                        return blockState.func_177229_b((IProperty)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
                    }
                    return true;
                }
                return isInterested;
            };
        }

        public boolean func_225506_g_() {
            if (ProductiveBeeEntity.this.field_226367_bG_ > 0) {
                return false;
            }
            if (ProductiveBeeEntity.this.func_226411_eD_()) {
                return false;
            }
            if (ProductiveBeeEntity.this.field_70170_p.func_72896_J() && ProductiveBeeEntity.this.canOperateDuringRain()) {
                return false;
            }
            if (ProductiveBeeEntity.this.field_70170_p.func_72911_I() && ProductiveBeeEntity.this.canOperateDuringThunder()) {
                return false;
            }
            if (ProductiveBeeEntity.this.field_70146_Z.nextFloat() <= 0.7f) {
                return false;
            }
            Optional optional = this.func_226507_o_();
            if (optional.isPresent()) {
                ProductiveBeeEntity.this.field_226368_bH_ = (BlockPos)optional.get();
                ProductiveBeeEntity.this.field_70699_by.func_75492_a((double)ProductiveBeeEntity.this.field_226368_bH_.func_177958_n() + 0.5, (double)ProductiveBeeEntity.this.field_226368_bH_.func_177956_o() + 0.5, (double)ProductiveBeeEntity.this.field_226368_bH_.func_177952_p() + 0.5, (double)1.2f);
                return true;
            }
            ProductiveBeeEntity.this.field_226367_bG_ = 70 + ProductiveBeeEntity.this.field_70170_p.field_73012_v.nextInt(50);
            return false;
        }
    }
}

