/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.entity.bee.hive;

import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.Collection;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class CreeperBeeEntity
extends ProductiveBeeEntity {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(CreeperBeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(CreeperBeeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private float explosionRadius = 1.6f;

    public CreeperBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.beeAttributes.put(BeeAttributes.TEMPER, 2);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    public void func_70071_h_() {
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            this.lastActiveTime = this.timeSinceIgnited;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    public void attackTarget(LivingEntity target) {
        if (this.func_70089_S()) {
            this.setCreeperState(1);
        }
    }

    private void explode() {
        Explosion.Mode explosionMode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
        float f = (Boolean)this.field_70180_af.func_187225_a(POWERED) != false ? 2.0f : 1.0f;
        this.field_70729_aU = true;
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionRadius * f, explosionMode);
        this.func_70106_y();
        this.spawnLingeringCloud();
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }
}

