/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.fluid;

import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class HoneyFluid
extends FlowingFluid {
    public static final ResourceLocation STILL = new ResourceLocation("productivebees", "block/honey/still");
    public static final ResourceLocation FLOWING = new ResourceLocation("productivebees", "block/honey/flow");
    public static final ResourceLocation OVERLAY = new ResourceLocation("productivebees", "block/honey/overlay");

    public Fluid func_210197_e() {
        return (Fluid)ModFluids.HONEY_FLOWING.get();
    }

    public Fluid func_210198_f() {
        return (Fluid)ModFluids.HONEY.get();
    }

    public Item func_204524_b() {
        return (Item)ModItems.HONEY_BUCKET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World worldIn, BlockPos pos, IFluidState state, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_180495_p(blockpos).func_196958_f() && !worldIn.func_180495_p(blockpos).func_200015_d((IBlockReader)worldIn, blockpos) && random.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226139_eT_, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)STILL, (ResourceLocation)FLOWING).overlay(OVERLAY).translationKey("fluid.productivebees.honey").color(-28394).density(3000).viscosity(6000).build((Fluid)ModFluids.HONEY.get());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return ParticleTypes.field_229427_ag_;
    }

    protected void func_205580_a(IWorld world, BlockPos pos, BlockState state) {
        this.triggerEffects(world, pos);
    }

    public int func_185698_b(IWorldReader world) {
        return world.func_201675_m().func_177500_n() ? 6 : 3;
    }

    public BlockState func_204527_a(IFluidState state) {
        return (BlockState)((FlowingFluidBlock)ModBlocks.HONEY.get()).func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(HoneyFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == ModFluids.HONEY.get() || fluidIn == ModFluids.HONEY_FLOWING.get();
    }

    public int func_204528_b(IWorldReader world) {
        return world.func_201675_m().func_177500_n() ? 1 : 2;
    }

    public boolean func_215665_a(IFluidState state, IBlockReader world, BlockPos pos, Fluid fluid, Direction direction) {
        return state.func_215679_a(world, pos) >= 0.44444445f && fluid.func_207185_a(FluidTags.field_206959_a);
    }

    public int func_205569_a(IWorldReader world) {
        return world.func_201675_m().func_177495_o() ? 10 : 30;
    }

    public int func_215667_a(World world, BlockPos pos, IFluidState state, IFluidState ifluidstate) {
        int i = this.func_205569_a((IWorldReader)world);
        if (!(state.func_206888_e() || ifluidstate.func_206888_e() || ((Boolean)state.func_177229_b((IProperty)field_207209_a)).booleanValue() || ((Boolean)ifluidstate.func_177229_b((IProperty)field_207209_a)).booleanValue() || !(ifluidstate.func_215679_a((IBlockReader)world, pos) > state.func_215679_a((IBlockReader)world, pos)) || world.func_201674_k().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    private void triggerEffects(IWorld world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_226139_eT_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends HoneyFluid {
        public int func_207192_d(IFluidState state) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends HoneyFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState state) {
            return (Integer)state.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

