/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.datafixers.Dynamic;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

public class OreSolitaryNestFeature
extends SolitaryNestFeature {
    private final float probability;
    private int yMin;
    private int yMax;

    public OreSolitaryNestFeature(float probability, Function<Dynamic<?>, ? extends ReplaceBlockConfig> configFactory) {
        this(probability, configFactory, 0, 64);
    }

    public OreSolitaryNestFeature(float probability, Function<Dynamic<?>, ? extends ReplaceBlockConfig> configFactory, int yMin, int yMax) {
        super(probability, configFactory);
        this.probability = probability;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    @Override
    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, ReplaceBlockConfig featureConfig) {
        if (rand.nextFloat() > this.probability) {
            return false;
        }
        pos = pos.func_177970_e(rand.nextInt(14)).func_177965_g(rand.nextInt(14));
        pos = pos.func_177981_b(this.yMin);
        BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)featureConfig.field_202457_a.func_177230_c());
        while (pos.func_177956_o() < this.yMax) {
            if (!matcher.test(world.func_180495_p(pos = pos.func_177984_a()))) continue;
            this.placeNest(world, pos, featureConfig);
        }
        return true;
    }
}

