/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.datafixers.Dynamic;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.block.SolitaryNest;
import cy.jdkdigital.productivebees.tileentity.SolitaryNestTileEntity;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

public class SolitaryNestFeature
extends Feature<ReplaceBlockConfig> {
    private final float probability;
    private boolean placeOntop;

    public SolitaryNestFeature(float probability, Function<Dynamic<?>, ? extends ReplaceBlockConfig> configFactory) {
        this(probability, configFactory, false);
    }

    public SolitaryNestFeature(float probability, Function<Dynamic<?>, ? extends ReplaceBlockConfig> configFactory, boolean placeOntop) {
        super(configFactory);
        this.probability = probability;
        this.placeOntop = placeOntop;
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, ReplaceBlockConfig featureConfig) {
        if (this.nestShouldNotGenerate(featureConfig) || rand.nextFloat() > this.probability) {
            return false;
        }
        pos = pos.func_177970_e(rand.nextInt(14)).func_177965_g(rand.nextInt(14));
        while (pos.func_177956_o() < 50 || !world.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        if (!this.placeOntop) {
            pos = pos.func_177977_b();
        }
        return this.placeNest(world, pos, featureConfig);
    }

    protected boolean nestShouldNotGenerate(ReplaceBlockConfig featureConfig) {
        return (Boolean)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("enable_" + featureConfig.field_202458_b.func_177230_c().getRegistryName()).get() == false;
    }

    protected boolean placeNest(IWorld world, BlockPos pos, ReplaceBlockConfig featureConfig) {
        boolean match;
        BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)featureConfig.field_202457_a.func_177230_c());
        boolean bl = match = this.placeOntop ? matcher.test(world.func_180495_p(pos.func_177977_b())) : matcher.test(world.func_180495_p(pos));
        if (match) {
            Direction direction = Direction.UP;
            for (Direction dir : BlockStateProperties.field_208155_H.func_177700_c()) {
                BlockPos blockPos = pos.func_177967_a(dir, 1);
                if (!world.func_175623_d(blockPos)) continue;
                direction = dir;
                break;
            }
            boolean result = world.func_180501_a(pos, (BlockState)featureConfig.field_202458_b.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction), 1);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SolitaryNestTileEntity) {
                SolitaryNestTileEntity nestTileEntity = (SolitaryNestTileEntity)tileEntity;
                ProductiveBees.LOGGER.debug("Placed nest at " + pos + " " + featureConfig.field_202458_b);
                EntityType<BeeEntity> beeType = SolitaryNestTileEntity.getProducibleBeeType(world.func_201672_e(), pos, (SolitaryNest)world.func_180495_p(pos).func_177230_c());
                if (beeType != null) {
                    BeeEntity newBee = (BeeEntity)beeType.func_200721_a(world.func_201672_e());
                    newBee.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    nestTileEntity.func_226962_a_((Entity)newBee, false, world.func_201674_k().nextInt(599));
                }
            }
            return result;
        }
        return false;
    }
}

