/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.datafixers.Dynamic;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

public class StructureSolitaryNestFeature
extends SolitaryNestFeature {
    private final float probability;
    private final int offsetSpan;

    public StructureSolitaryNestFeature(float probability, Function<Dynamic<?>, ? extends ReplaceBlockConfig> configFactory, int offsetSpan) {
        super(probability, configFactory);
        this.offsetSpan = offsetSpan;
        this.probability = probability;
    }

    @Override
    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, ReplaceBlockConfig featureConfig) {
        block5: {
            if (this.nestShouldNotGenerate(featureConfig) || rand.nextFloat() > this.probability) {
                return false;
            }
            pos = pos.func_177970_e(rand.nextInt(14)).func_177965_g(rand.nextInt(14)).func_177981_b(50);
            BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)featureConfig.field_202457_a.func_177230_c());
            if (!matcher.test(world.func_180495_p(pos))) {
                for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
                    if (!matcher.test(world.func_180495_p(pos.func_177967_a(dir, 2)))) continue;
                    pos = pos.func_177967_a(dir, 3);
                    break block5;
                }
                return false;
            }
        }
        pos = pos.func_177967_a(Direction.UP, world.func_201674_k().nextInt(this.offsetSpan));
        block1: for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
            int i = 0;
            while (++i <= 5) {
                if (!world.func_175623_d(pos.func_177967_a(dir, i))) continue;
                pos = pos.func_177967_a(dir, i - 1);
                break block1;
            }
        }
        return this.placeNest(world, pos, featureConfig);
    }
}

