/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import cy.jdkdigital.productivebees.client.render.entity.DyeBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.SlimyBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.SolitaryBeeRenderer;
import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.hive.CreeperBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.hive.EnderBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.hive.SkeletalBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.hive.WitherBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.hive.ZombieBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.BlazingBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.DraconicBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.GlowingBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.MagmaticBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.QuartzBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.nesting.SlimyBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.AshyMiningBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.BlueBandedBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.ChocolateMiningBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.DiggerBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.GreenCarpenterBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.LeafcutterBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.MasonBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.NeonCuckooBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.NomadBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.ReedBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.ResinBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.SweatyBeeEntity;
import cy.jdkdigital.productivebees.entity.bee.solitary.YellowBlackCarpenterBeeEntity;
import cy.jdkdigital.productivebees.init.ModItemGroups;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.item.SpawnEgg;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> HIVE_BEES = new DeferredRegister(ForgeRegistries.ENTITIES, "productivebees");
    public static final DeferredRegister<EntityType<?>> SOLITARY_BEES = new DeferredRegister(ForgeRegistries.ENTITIES, "productivebees");
    public static RegistryObject<EntityType<BeeEntity>> IRON_BEE = ModEntities.createHiveBee("iron_bee", ProductiveBeeEntity::new, 6238757, 0xCDCDCD);
    public static RegistryObject<EntityType<BeeEntity>> GOLD_BEE = ModEntities.createHiveBee("gold_bee", ProductiveBeeEntity::new, 6238757, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> COAL_BEE = ModEntities.createHiveBee("coal_bee", ProductiveBeeEntity::new, 0x222525, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> REDSTONE_BEE = ModEntities.createHiveBee("redstone_bee", ProductiveBeeEntity::new, 6238757, 13645345);
    public static RegistryObject<EntityType<BeeEntity>> LAPIS_BEE = ModEntities.createHiveBee("lapis_bee", ProductiveBeeEntity::new, 6238757, 4276966);
    public static RegistryObject<EntityType<BeeEntity>> EMERALD_BEE = ModEntities.createHiveBee("emerald_bee", ProductiveBeeEntity::new, 6238757, 3000655);
    public static RegistryObject<EntityType<BeeEntity>> DIAMOND_BEE = ModEntities.createHiveBee("diamond_bee", ProductiveBeeEntity::new, 6238757, 4055009);
    public static RegistryObject<EntityType<BeeEntity>> DYE_BEE = ModEntities.createHiveBee("dye_bee", ProductiveBeeEntity::new, 6238757, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> CREEPER_BEE = ModEntities.createHiveBee("creeper_bee", CreeperBeeEntity::new, 6238757, 894731);
    public static RegistryObject<EntityType<BeeEntity>> ZOMBIE_BEE = ModEntities.createHiveBee("zombie_bee", ZombieBeeEntity::new, 6238757, 7969893);
    public static RegistryObject<EntityType<BeeEntity>> ENDER_BEE = ModEntities.createHiveBee("ender_bee", EnderBeeEntity::new, 6238757, 0x161616);
    public static RegistryObject<EntityType<BeeEntity>> SKELETAL_BEE = ModEntities.createHiveBee("skeletal_bee", SkeletalBeeEntity::new, 6238757, 0xC1C1C1);
    public static RegistryObject<EntityType<BeeEntity>> WITHER_BEE = ModEntities.createHiveBee("wither_bee", WitherBeeEntity::new, 6238757, 0x141414);
    public static RegistryObject<EntityType<BeeEntity>> GLOWING_BEE = ModEntities.createHiveBee("glowing_bee", GlowingBeeEntity::new, 6238757, 0xFCFC00);
    public static RegistryObject<EntityType<BeeEntity>> QUARTZ_BEE = ModEntities.createHiveBee("quartz_bee", QuartzBeeEntity::new, 6238757, 0xEEEAE6);
    public static RegistryObject<EntityType<BeeEntity>> MAGMATIC_BEE = ModEntities.createHiveBee("magmatic_bee", MagmaticBeeEntity::new, 6238757, 0x340000);
    public static RegistryObject<EntityType<BeeEntity>> BLAZING_BEE = ModEntities.createHiveBee("blazing_bee", BlazingBeeEntity::new, 6238757, 16763648);
    public static RegistryObject<EntityType<BeeEntity>> DRACONIC_BEE = ModEntities.createHiveBee("draconic_bee", DraconicBeeEntity::new, 6238757, 0x1C1C1C);
    public static RegistryObject<EntityType<BeeEntity>> SLIMY_BEE = ModEntities.createHiveBee("slimy_bee", SlimyBeeEntity::new, 6238757, 8306542);
    public static RegistryObject<EntityType<BeeEntity>> ASHY_MINING_BEE = ModEntities.createSolitaryBee("ashy_mining_bee", AshyMiningBeeEntity::new, 6238757, 11709345);
    public static RegistryObject<EntityType<BeeEntity>> BLUE_BANDED_BEE = ModEntities.createSolitaryBee("blue_banded_bee", BlueBandedBeeEntity::new, 6238757, 9615358);
    public static RegistryObject<EntityType<BeeEntity>> GREEN_CARPENTER_BEE = ModEntities.createSolitaryBee("green_carpenter_bee", GreenCarpenterBeeEntity::new, 6238757, 9615358);
    public static RegistryObject<EntityType<BeeEntity>> YELLOW_BLACK_CARPENTER_BEE = ModEntities.createSolitaryBee("yellow_black_carpenter_bee", YellowBlackCarpenterBeeEntity::new, 6238757, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> CHOCOLATE_MINING_BEE = ModEntities.createSolitaryBee("chocolate_mining_bee", ChocolateMiningBeeEntity::new, 6238757, 11709345);
    public static RegistryObject<EntityType<BeeEntity>> DIGGER_BEE = ModEntities.createSolitaryBee("digger_bee", DiggerBeeEntity::new, 6238757, 8875079);
    public static RegistryObject<EntityType<BeeEntity>> LEAFCUTTER_BEE = ModEntities.createSolitaryBee("leafcutter_bee", LeafcutterBeeEntity::new, 6238757, 2057258);
    public static RegistryObject<EntityType<BeeEntity>> MASON_BEE = ModEntities.createSolitaryBee("mason_bee", MasonBeeEntity::new, 6238757, 12226382);
    public static RegistryObject<EntityType<BeeEntity>> NEON_CUCKOO_BEE = ModEntities.createSolitaryBee("neon_cuckoo_bee", NeonCuckooBeeEntity::new, 6238757, 9615358);
    public static RegistryObject<EntityType<BeeEntity>> NOMAD_BEE = ModEntities.createSolitaryBee("nomad_bee", NomadBeeEntity::new, 6238757, 14529911);
    public static RegistryObject<EntityType<BeeEntity>> REED_BEE = ModEntities.createSolitaryBee("reed_bee", ReedBeeEntity::new, 6238757, 13806336);
    public static RegistryObject<EntityType<BeeEntity>> RESIN_BEE = ModEntities.createSolitaryBee("resin_bee", ResinBeeEntity::new, 6238757, 13939231);
    public static RegistryObject<EntityType<BeeEntity>> SWEATY_BEE = ModEntities.createSolitaryBee("sweaty_bee", SweatyBeeEntity::new, 6238757, 9748939);
    public static RegistryObject<EntityType<BeeEntity>> ALUMINIUM_BEE = ModEntities.createHiveBee("aluminium_bee", ProductiveBeeEntity::new, 9748939, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> AMBER_BEE = ModEntities.createHiveBee("amber_bee", ProductiveBeeEntity::new, 13806336, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> BRASS_BEE = ModEntities.createHiveBee("brass_bee", ProductiveBeeEntity::new, 11309338, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> BRONZE_BEE = ModEntities.createHiveBee("bronze_bee", ProductiveBeeEntity::new, 13939231, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> COPPER_BEE = ModEntities.createHiveBee("copper_bee", ProductiveBeeEntity::new, 14851873, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> ELECTRUM_BEE = ModEntities.createHiveBee("electrum_bee", ProductiveBeeEntity::new, 16762718, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> INVAR_BEE = ModEntities.createHiveBee("invar_bee", ProductiveBeeEntity::new, 10661549, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> LEAD_BEE = ModEntities.createHiveBee("lead_bee", ProductiveBeeEntity::new, 6241124, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> NICKEL_BEE = ModEntities.createHiveBee("nickel_bee", ProductiveBeeEntity::new, 9429476, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> OSMIUM_BEE = ModEntities.createHiveBee("osmium_bee", ProductiveBeeEntity::new, 5021110, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> PLATINUM_BEE = ModEntities.createHiveBee("platinum_bee", ProductiveBeeEntity::new, 12118748, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> RADIOACTIVE_BEE = ModEntities.createHiveBee("radioactive_bee", ProductiveBeeEntity::new, 62574, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> SILVER_BEE = ModEntities.createHiveBee("silver_bee", ProductiveBeeEntity::new, 12836322, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> STEEL_BEE = ModEntities.createHiveBee("steel_bee", ProductiveBeeEntity::new, 6647662, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> TIN_BEE = ModEntities.createHiveBee("tin_bee", ProductiveBeeEntity::new, 15389140, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> TITANIUM_BEE = ModEntities.createHiveBee("titanium_bee", ProductiveBeeEntity::new, 11068133, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> TUNGSTEN_BEE = ModEntities.createHiveBee("tungsten_bee", ProductiveBeeEntity::new, 1926751, 15582019);
    public static RegistryObject<EntityType<BeeEntity>> ZINC_BEE = ModEntities.createHiveBee("zinc_bee", ProductiveBeeEntity::new, 15389140, 15582019);

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createHiveBee(String name, EntityType.IFactory<E> supplier, int primaryColor, int secondaryColor) {
        return ModEntities.createBee(HIVE_BEES, name, supplier, primaryColor, secondaryColor, ModItemGroups.PRODUCTIVE_BEES);
    }

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createSolitaryBee(String name, EntityType.IFactory<E> supplier, int primaryColor, int secondaryColor) {
        return ModEntities.createBee(SOLITARY_BEES, name, supplier, primaryColor, secondaryColor, ModItemGroups.PRODUCTIVE_BEES);
    }

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createBee(DeferredRegister<EntityType<?>> registry, String name, EntityType.IFactory<E> supplier, int primaryColor, int secondaryColor, ItemGroup itemGroup) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(supplier, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.6f);
        if (name.equals("magmatic_bee")) {
            builder.func_220320_c();
        }
        RegistryObject entity = registry.register(name, () -> builder.func_206830_a("productivebees:" + name));
        if (itemGroup != null) {
            RegistryObject spawnEgg = ModItems.ITEMS.register("spawn_egg_" + name, () -> new SpawnEgg(() -> ((RegistryObject)entity).get(), primaryColor, secondaryColor, new Item.Properties().func_200916_a(itemGroup)));
            ModItems.SPAWN_EGGS.add((RegistryObject<Item>)spawnEgg);
        }
        return entity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRendering() {
        EntityType bee;
        for (RegistryObject registryObject : HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.func_210760_d().contains("slimy_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, SlimyBeeRenderer::new);
                continue;
            }
            if (bee.func_210760_d().contains("dye_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, DyeBeeRenderer::new);
                continue;
            }
            RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, ProductiveBeeRenderer::new);
        }
        for (RegistryObject registryObject : SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, SolitaryBeeRenderer::new);
        }
    }
}

