/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import cy.jdkdigital.productivebees.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningBigRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import java.util.function.Supplier;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModRecipeTypes {
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = new DeferredRegister(ForgeRegistries.RECIPE_SERIALIZERS, "productivebees");
    public static final RegistryObject<IRecipeSerializer<?>> ADVANCED_BEEHIVE = ModRecipeTypes.createRecipeType("advanced_beehive", () -> new AdvancedBeehiveRecipe.Serializer<AdvancedBeehiveRecipe>(AdvancedBeehiveRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> CENTRIFUGE = ModRecipeTypes.createRecipeType("centrifuge", () -> new CentrifugeRecipe.Serializer<CentrifugeRecipe>(CentrifugeRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> BEE_BREEDING = ModRecipeTypes.createRecipeType("bee_breeding", () -> new BeeBreedingRecipe.Serializer<BeeBreedingRecipe>(BeeBreedingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> BEE_SPAWNING = ModRecipeTypes.createRecipeType("bee_spawning", () -> new BeeSpawningRecipe.Serializer<BeeSpawningRecipe>(BeeSpawningRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> BEE_SPAWNING_BIG = ModRecipeTypes.createRecipeType("bee_spawning_big", () -> new BeeSpawningRecipe.Serializer<BeeSpawningBigRecipe>(BeeSpawningBigRecipe::new));

    public static <B extends IRecipeSerializer<?>> RegistryObject<B> createRecipeType(String name, Supplier<? extends B> supplier) {
        return RECIPE_SERIALIZERS.register(name, supplier);
    }
}

