/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BeeSpawningRecipeCategory
implements IRecipeCategory<BeeSpawningRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static final HashMap<Integer, List<Integer>> BEE_POSITIONS = new HashMap<Integer, List<Integer>>(){
        {
            this.put(0, new ArrayList<Integer>(){
                {
                    this.add(79);
                    this.add(18);
                }
            });
            this.put(1, new ArrayList<Integer>(){
                {
                    this.add(97);
                    this.add(28);
                }
            });
            this.put(2, new ArrayList<Integer>(){
                {
                    this.add(79);
                    this.add(38);
                }
            });
        }
    };

    public BeeSpawningRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_spawning_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.COARSE_DIRT_NEST.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BEE_SPAWNING_UID;
    }

    @Nonnull
    public Class<? extends BeeSpawningRecipe> getRecipeClass() {
        return BeeSpawningRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.productivebees.bee_spawning", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BeeSpawningRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.ingredient}));
        ingredients.setOutputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BeeSpawningRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 4, 26);
        itemStacks.set(ingredients);
        IGuiIngredientGroup ingredientStacks = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        int offset = ingredients.getInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT).size();
        IntStream.range(offset, recipe.output.size() + offset).forEach(i -> {
            if (i - offset > 3) {
                return;
            }
            List<Integer> pos = BEE_POSITIONS.get(i - offset);
            ingredientStacks.init(i, false, pos.get(0).intValue(), pos.get(1).intValue());
        });
        ingredientStacks.set(ingredients);
    }
}

