/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.integrations.jei.AdvancedBeehiveRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeBreedingRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeBigCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.CentrifugeRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientHelper;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientRenderer;
import cy.jdkdigital.productivebees.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningBigRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProductiveBeesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("productivebees", "productivebees");
    public static final ResourceLocation CATEGORY_ADVANCED_BEEHIVE_UID = new ResourceLocation("productivebees", "advanced_beehive");
    public static final ResourceLocation CATEGORY_BEE_BREEDING_UID = new ResourceLocation("productivebees", "bee_breeding");
    public static final ResourceLocation CATEGORY_BEE_SPAWNING_UID = new ResourceLocation("productivebees", "bee_spawning");
    public static final ResourceLocation CATEGORY_BEE_SPAWNING_BIG_UID = new ResourceLocation("productivebees", "bee_spawning_big");
    public static final ResourceLocation CATEGORY_CENTRIFUGE_UID = new ResourceLocation("productivebees", "centrifuge");
    public static final IIngredientType<BeeIngredient> BEE_INGREDIENT = () -> BeeIngredient.class;

    public ProductiveBeesJeiPlugin() {
        BeeIngredientFactory.createList();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ADVANCED_OAK_BEEHIVE.get()), new ResourceLocation[]{CATEGORY_ADVANCED_BEEHIVE_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CENTRIFUGE.get()), new ResourceLocation[]{CATEGORY_CENTRIFUGE_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.COARSE_DIRT_NEST.get()), new ResourceLocation[]{CATEGORY_BEE_SPAWNING_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.OAK_WOOD_NEST.get()), new ResourceLocation[]{CATEGORY_BEE_SPAWNING_BIG_UID});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedBeehiveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeBreedingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeBigCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(BEE_INGREDIENT, new ArrayList<BeeIngredient>(BeeIngredientFactory.getOrCreateList().values()), (IIngredientHelper)new BeeIngredientHelper(), (IIngredientRenderer)new BeeIngredientRenderer());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        Map advancedBeehiveRecipesMap = recipeManager.func_215366_a(AdvancedBeehiveRecipe.ADVANCED_BEEHIVE);
        registration.addRecipes(advancedBeehiveRecipesMap.values(), CATEGORY_ADVANCED_BEEHIVE_UID);
        Map centrifugeRecipesMap = recipeManager.func_215366_a(CentrifugeRecipe.CENTRIFUGE);
        registration.addRecipes(centrifugeRecipesMap.values(), CATEGORY_CENTRIFUGE_UID);
        Map beeSpawningRecipesMap = recipeManager.func_215366_a(BeeSpawningRecipe.BEE_SPAWNING);
        registration.addRecipes(beeSpawningRecipesMap.values(), CATEGORY_BEE_SPAWNING_UID);
        Map beeSpawningRecipesBigMap = recipeManager.func_215366_a(BeeSpawningBigRecipe.BEE_SPAWNING);
        registration.addRecipes(beeSpawningRecipesBigMap.values(), CATEGORY_BEE_SPAWNING_BIG_UID);
        Map beeBreedingRecipeMap = recipeManager.func_215366_a(BeeBreedingRecipe.BEE_BREEDING);
        registration.addRecipes(beeBreedingRecipeMap.values(), CATEGORY_BEE_BREEDING_UID);
        List<String> notInfoBees = Arrays.asList("minecraft:bee", "aluminium_bee", "brass_bee", "bronze_bee", "copper_bee", "invar_bee", "lead_bee", "nickel_bee", "osmium_bee", "platinum_bee", "radioactive_bee", "silver_bee", "steel_bee", "tin_bee", "titanium_bee", "tungsten_bee", "zinc_bee", "amber_bee");
        for (Map.Entry<String, BeeIngredient> entry : BeeIngredientFactory.getOrCreateList().entrySet()) {
            String beeId = entry.getKey().replace("productivebees:", "");
            if (notInfoBees.contains(beeId)) continue;
            registration.addIngredientInfo((Object)entry.getValue(), BEE_INGREDIENT, new String[]{"productivebees.ingredient.description." + beeId});
        }
        List<String> itemInfos = Arrays.asList("inactive_dragon_egg", "sand_nest", "gravel_nest", "coarse_dirt_nest", "oak_wood_nest", "spruce_wood_nest", "acacia_wood_nest", "dark_oak_wood_nest", "jungle_wood_nest", "birch_wood_nest", "end_stone_nest", "obsidian_nest", "glowstone_nest", "nether_brick_nest", "nether_quartz_nest");
        for (String itemName : itemInfos) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", itemName));
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)item), VanillaTypes.ITEM, new String[]{"productivebees.ingredient.description." + itemName});
        }
    }
}

