/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.container.gui.AdvancedBeehiveScreen;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class BeeIngredientRenderer
implements IIngredientRenderer<BeeIngredient> {
    private final Map<Integer, Map<String, Integer>> renderSettings = new HashMap<Integer, Map<String, Integer>>(){
        {
            this.put(0, new HashMap<String, Integer>(){
                {
                    this.put("scale", 128);
                    this.put("iconX", 14);
                    this.put("iconY", 14);
                    this.put("iconU", 20);
                    this.put("iconV", 20);
                }
            });
            this.put(1, new HashMap<String, Integer>(){
                {
                    this.put("scale", 128);
                    this.put("iconX", 12);
                    this.put("iconY", 12);
                    this.put("iconU", 20);
                    this.put("iconV", 20);
                }
            });
        }
    };

    public void render(int xPosition, int yPosition, @Nullable BeeIngredient beeIngredient) {
        if (beeIngredient == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        ResourceLocation resLocation = AdvancedBeehiveScreen.getBeeTexture(beeIngredient.getBeeType().getRegistryName(), ProductiveBees.proxy.getClientWorld());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resLocation);
        Map<String, Integer> iconSettings = this.renderSettings.get(beeIngredient.getRenderType());
        float scale = 1.0f / (float)iconSettings.get("scale").intValue();
        int iconX = iconSettings.get("iconX");
        int iconY = iconSettings.get("iconY");
        int iconU = iconSettings.get("iconU");
        int iconV = iconSettings.get("iconV");
        BufferBuilder renderBuffer = Tessellator.func_178181_a().func_178180_c();
        renderBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderBuffer.func_225582_a_((double)xPosition, (double)(yPosition + iconY), 0.0).func_225583_a_((float)iconU * scale, (float)(iconV + iconY) * scale).func_181675_d();
        renderBuffer.func_225582_a_((double)(xPosition + iconX), (double)(yPosition + iconY), 0.0).func_225583_a_((float)(iconU + iconX) * scale, (float)(iconV + iconY) * scale).func_181675_d();
        renderBuffer.func_225582_a_((double)(xPosition + iconX), (double)yPosition, 0.0).func_225583_a_((float)(iconU + iconX) * scale, (float)iconV * scale).func_181675_d();
        renderBuffer.func_225582_a_((double)xPosition, (double)yPosition, 0.0).func_225583_a_((float)iconU * scale, (float)iconV * scale).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    @Nonnull
    public List<String> getTooltip(BeeIngredient beeIngredient, ITooltipFlag iTooltipFlag) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(beeIngredient.getBeeType().func_212546_e().func_150254_d());
        list.add(TextFormatting.DARK_GRAY + "" + beeIngredient.getBeeType().getRegistryName());
        return list;
    }
}

