/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.item;

import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class BeeCage
extends Item {
    public BeeCage(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("filled"), (itemStack, world, entity) -> BeeCage.isFilled(itemStack) ? 1.0f : 0.0f);
    }

    public static boolean isFilled(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("entity");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World playerWorld = context.func_195999_j().func_130014_f_();
        ItemStack stack = context.func_195996_i();
        if (playerWorld.func_201670_d() || !BeeCage.isFilled(stack)) {
            return ActionResultType.FAIL;
        }
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Entity entity = this.getEntityFromStack(stack, worldIn, true);
        BlockPos blockPos = pos.func_177972_a(context.func_196000_l());
        entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        worldIn.func_217376_c(entity);
        context.func_195999_j().field_71071_by.func_184437_d(stack);
        return ActionResultType.SUCCESS;
    }

    public boolean func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity targetIn, Hand hand) {
        if (targetIn.func_130014_f_().func_201670_d() || !(targetIn instanceof BeeEntity) || !targetIn.func_70089_S() || BeeCage.isFilled(itemStack)) {
            return false;
        }
        BeeEntity target = (BeeEntity)targetIn;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("entity", EntityType.func_200718_a((EntityType)target.func_200600_R()).toString());
        if (target.func_145818_k_()) {
            nbt.func_74778_a("name", target.func_200201_e().func_150254_d());
        } else {
            nbt.func_74778_a("name", target.func_200200_C_().func_150254_d());
        }
        target.func_189511_e(nbt);
        nbt.func_74757_a("isProductiveBee", target instanceof ProductiveBeeEntity);
        String modId = target.func_200600_R().getRegistryName().func_110624_b();
        String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
        if (modId.equals("minecraft")) {
            modName = "Minecraft";
        }
        nbt.func_74778_a("mod", modName);
        ItemStack cageStack = new ItemStack((IItemProvider)itemStack.func_77973_b());
        cageStack.func_77982_d(nbt);
        itemStack.func_190918_g(1);
        if (!player.field_71071_by.func_70441_a(cageStack)) {
            player.func_71019_a(cageStack, false);
        }
        player.func_184609_a(hand);
        target.remove(true);
        return true;
    }

    @Nullable
    public Entity getEntityFromStack(ItemStack stack, World world, boolean withInfo) {
        EntityType type = EntityType.func_220327_a((String)stack.func_77978_p().func_74779_i("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.func_200721_a(world);
            if (withInfo) {
                entity.func_70020_e(stack.func_77978_p());
            }
            return entity;
        }
        return null;
    }

    @Nonnull
    public ITextComponent func_200295_i(ItemStack stack) {
        if (!BeeCage.isFilled(stack)) {
            return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
        }
        String entityId = stack.func_77978_p().func_74779_i("name");
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]).func_150258_a(" (" + entityId + ")");
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            boolean hasStung = tag.func_74767_n("HasStung");
            if (hasStung) {
                list.add(new TranslationTextComponent("productivebees.information.health.dying", new Object[0]).func_211708_a(TextFormatting.RED).func_211708_a(TextFormatting.ITALIC));
            }
            if (tag.func_74767_n("isProductiveBee")) {
                String type = tag.func_74779_i("bee_type");
                ITextComponent type_value = new TranslationTextComponent("productivebees.information.attribute.type." + type, new Object[0]).func_211708_a(BeeCage.getColor(type));
                list.add(new TranslationTextComponent("productivebees.information.attribute.type", new Object[]{type_value}).func_211708_a(TextFormatting.DARK_GRAY));
                int productivity = tag.func_74762_e("bee_productivity");
                ITextComponent productivity_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.PRODUCTIVITY).get(productivity), new Object[0]).func_211708_a(BeeCage.getColor(productivity));
                list.add(new TranslationTextComponent("productivebees.information.attribute.productivity", new Object[]{productivity_value}).func_211708_a(TextFormatting.DARK_GRAY));
                int tolerance = tag.func_74762_e("bee_weather_tolerance");
                ITextComponent tolerance_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.WEATHER_TOLERANCE).get(tolerance), new Object[0]).func_211708_a(BeeCage.getColor(tolerance));
                list.add(new TranslationTextComponent("productivebees.information.attribute.weather_tolerance", new Object[]{tolerance_value}).func_211708_a(TextFormatting.DARK_GRAY));
                int behavior = tag.func_74762_e("bee_behavior");
                ITextComponent behavior_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.BEHAVIOR).get(behavior), new Object[0]).func_211708_a(BeeCage.getColor(behavior));
                list.add(new TranslationTextComponent("productivebees.information.attribute.behavior", new Object[]{behavior_value}).func_211708_a(TextFormatting.DARK_GRAY));
            } else {
                list.add(new StringTextComponent("Mod: " + tag.func_74779_i("mod")).func_211708_a(TextFormatting.DARK_AQUA));
            }
        }
    }

    private static TextFormatting getColor(String type) {
        switch (type) {
            case "hive": {
                return TextFormatting.YELLOW;
            }
            case "solitary": {
                return TextFormatting.GRAY;
            }
        }
        return TextFormatting.WHITE;
    }

    private static TextFormatting getColor(int level) {
        switch (level) {
            case -3: {
                return TextFormatting.RED;
            }
            case -2: {
                return TextFormatting.DARK_RED;
            }
            case -1: {
                return TextFormatting.YELLOW;
            }
            case 1: {
                return TextFormatting.GREEN;
            }
            case 2: {
                return TextFormatting.BLUE;
            }
            case 3: {
                return TextFormatting.GOLD;
            }
        }
        return TextFormatting.LIGHT_PURPLE;
    }
}

