/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AdvancedBeehiveRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<AdvancedBeehiveRecipe> ADVANCED_BEEHIVE = IRecipeType.func_222147_a((String)"productivebees:advanced_beehive");
    public final ResourceLocation id;
    public final BeeIngredient ingredient;
    public final Map<ItemStack, IntArrayNBT> output;
    public final double chance;

    public AdvancedBeehiveRecipe(ResourceLocation id, BeeIngredient ingredient, Map<ItemStack, IntArrayNBT> output, double chance) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.chance = chance;
    }

    public String toString() {
        return "AdvancedBeehiveRecipe{id=" + this.id + ", bee=" + this.ingredient.getBeeType() + ", outputs=" + this.output + ", chance=" + this.chance + '}';
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof BeeHelper.BeeInventory) {
            String beeName = ((BeeHelper.BeeInventory)inv).getBeeIdentifier();
            return beeName.equals(this.ingredient.getBeeType().getRegistryName().toString());
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.ADVANCED_BEEHIVE.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return ADVANCED_BEEHIVE;
    }

    public static class Serializer<T extends AdvancedBeehiveRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation id, JsonObject json) {
            String beeName = JSONUtils.func_151200_h((JsonObject)json, (String)"ingredient");
            BeeIngredient beeIngredient = BeeIngredientFactory.getOrCreateList().get(beeName);
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
            HashMap<ItemStack, IntArrayNBT> outputs = new HashMap<ItemStack, IntArrayNBT>();
            jsonArray.forEach(jsonElement -> {
                Ingredient produce;
                ItemStack[] stacks;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String ingredientKey = "item_produce";
                if (((Boolean)ProductiveBeesConfig.GENERAL.enableCombProduce.get()).booleanValue()) {
                    ingredientKey = "comb_produce";
                }
                if ((stacks = (produce = JSONUtils.func_151202_d((JsonObject)json, (String)ingredientKey) ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)jsonObject, (String)ingredientKey)) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)ingredientKey))).func_193365_a()).length > 0) {
                    int min = 1;
                    int max = 1;
                    if (ingredientKey.equals("item_produce")) {
                        min = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"min", (int)1);
                        max = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"max", (int)1);
                    }
                    int chance = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"chance", (int)100);
                    IntArrayNBT nbt = new IntArrayNBT(new int[]{min, max, chance});
                    outputs.put(stacks[0], nbt);
                }
            });
            double chance = ProductiveBeeEntity.getProductionChance(beeName, 0.65);
            return this.factory.create(id, beeIngredient, outputs, chance);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                BeeIngredient ingredient = BeeIngredient.read(buffer);
                HashMap<ItemStack, IntArrayNBT> output = new HashMap<ItemStack, IntArrayNBT>();
                IntStream.range(0, buffer.readInt()).forEach(i -> output.put(buffer.func_150791_c(), new IntArrayNBT(new int[]{buffer.readInt(), buffer.readInt(), buffer.readInt()})));
                double chance = buffer.readDouble();
                return this.factory.create(id, ingredient, output, chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((AdvancedBeehiveRecipe)recipe).ingredient.write(buffer);
                buffer.writeInt(((AdvancedBeehiveRecipe)recipe).output.size());
                ((AdvancedBeehiveRecipe)recipe).output.forEach((key, value) -> {
                    buffer.func_150788_a(key);
                    buffer.writeInt(value.get(0).func_150287_d());
                    buffer.writeInt(value.get(1).func_150287_d());
                    buffer.writeInt(value.get(2).func_150287_d());
                });
                buffer.writeDouble(((AdvancedBeehiveRecipe)recipe).chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing recipe to packet.", (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends AdvancedBeehiveRecipe> {
            public T create(ResourceLocation var1, BeeIngredient var2, Map<ItemStack, IntArrayNBT> var3, double var4);
        }
    }
}

