/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeBreedingRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BeeBreedingRecipe> BEE_BREEDING = IRecipeType.func_222147_a((String)"productivebees:bee_breeding");
    public final ResourceLocation id;
    public final List<BeeIngredient> ingredients;
    public final List<BeeIngredient> offspring;

    public BeeBreedingRecipe(ResourceLocation id, List<BeeIngredient> ingredients, List<BeeIngredient> offspring) {
        this.id = id;
        this.ingredients = ingredients;
        this.offspring = offspring;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ProductiveBees.LOGGER.info("matching recipe " + this.offspring);
        if (inv instanceof BeeHelper.BeeInventory) {
            String beeName1 = ((BeeHelper.BeeInventory)inv).getBeeIdentifier(0);
            String beeName2 = ((BeeHelper.BeeInventory)inv).getBeeIdentifier(1);
            ProductiveBees.LOGGER.info("matching recipe for " + beeName1 + " an " + beeName2);
            boolean matches = true;
            for (BeeIngredient parent : this.ingredients) {
                String parentName = parent.getBeeType().getRegistryName().func_110623_a();
                ProductiveBees.LOGGER.info("checking " + parentName);
                if (parentName.equals(beeName1 + "_bee") || parentName.equals(beeName2 + "_bee")) continue;
                matches = false;
                break;
            }
            return matches;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_BREEDING.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_BREEDING;
    }

    public static class Serializer<T extends BeeBreedingRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T read(ResourceLocation id, JsonObject json) {
            String parentName1 = JSONUtils.func_151200_h((JsonObject)json, (String)"parent1");
            String parentName2 = JSONUtils.func_151200_h((JsonObject)json, (String)"parent2");
            ArrayList<BeeIngredient> children = new ArrayList<BeeIngredient>();
            JsonArray offspring = JSONUtils.func_151214_t((JsonObject)json, (String)"offspring");
            offspring.forEach(el -> {
                String child = el.getAsString();
                children.add(BeeIngredientFactory.getOrCreateList().get(child));
            });
            BeeIngredient beeIngredientParent1 = BeeIngredientFactory.getOrCreateList().get(parentName1);
            BeeIngredient beeIngredientParent2 = BeeIngredientFactory.getOrCreateList().get(parentName2);
            return this.factory.create(id, Arrays.asList(beeIngredientParent1, beeIngredientParent2), children);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            ArrayList<BeeIngredient> ingredients = new ArrayList<BeeIngredient>();
            ingredients.add(BeeIngredient.read(buffer));
            ingredients.add(BeeIngredient.read(buffer));
            ArrayList<BeeIngredient> offspring = new ArrayList<BeeIngredient>();
            IntStream.range(0, buffer.readInt()).forEach(i -> offspring.add(BeeIngredient.read(buffer)));
            return this.factory.create(id, ingredients, offspring);
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            for (BeeIngredient ingredient : ((BeeBreedingRecipe)recipe).ingredients) {
                ingredient.write(buffer);
            }
            buffer.writeInt(((BeeBreedingRecipe)recipe).offspring.size());
            ((BeeBreedingRecipe)recipe).offspring.forEach(child -> child.write(buffer));
        }

        public static interface IRecipeFactory<T extends BeeBreedingRecipe> {
            public T create(ResourceLocation var1, List<BeeIngredient> var2, List<BeeIngredient> var3);
        }
    }
}

