/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeSpawningRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BeeSpawningRecipe> BEE_SPAWNING = IRecipeType.func_222147_a((String)"productivebees:bee_spawning");
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final List<BeeIngredient> output;
    public final int repopulationCooldown;

    public BeeSpawningRecipe(ResourceLocation id, Ingredient ingredient, List<BeeIngredient> output, int repopulationCooldown) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.repopulationCooldown = repopulationCooldown;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_SPAWNING.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_SPAWNING;
    }

    public static class Serializer<T extends BeeSpawningRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
            ArrayList<BeeIngredient> output = new ArrayList<BeeIngredient>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                String beeName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"bee");
                output.add(BeeIngredientFactory.getOrCreateList().get(beeName));
            });
            int repopulationCooldown = JSONUtils.func_151208_a((JsonObject)json, (String)"repopulation_cooldown", (int)36000);
            return this.factory.create(id, ingredient, output, repopulationCooldown);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                ArrayList<BeeIngredient> output = new ArrayList<BeeIngredient>();
                IntStream.range(0, buffer.readInt()).forEach(i -> output.add(BeeIngredient.read(buffer)));
                int repopulationCooldown = buffer.readInt();
                return this.factory.create(id, ingredient, output, repopulationCooldown);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((BeeSpawningRecipe)recipe).ingredient.func_199564_a(buffer);
                buffer.writeInt(((BeeSpawningRecipe)recipe).output.size());
                for (BeeIngredient beeOutput : ((BeeSpawningRecipe)recipe).output) {
                    beeOutput.write(buffer);
                }
                buffer.writeInt(((BeeSpawningRecipe)recipe).repopulationCooldown);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing recipe to packet.", (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeSpawningRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, List<BeeIngredient> var3, int var4);
        }
    }
}

