/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CentrifugeRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<CentrifugeRecipe> CENTRIFUGE = IRecipeType.func_222147_a((String)"productivebees:centrifuge");
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final Map<ItemStack, IntArrayNBT> output;

    public CentrifugeRecipe(ResourceLocation id, Ingredient ingredient, Map<ItemStack, IntArrayNBT> output) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (this.ingredient.func_193365_a().length > 0) {
            Item invItem = inv.func_70301_a(1).func_77973_b();
            for (ItemStack possibleInput : this.ingredient.func_193365_a()) {
                if (!possibleInput.func_77973_b().equals(invItem)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.CENTRIFUGE.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return CENTRIFUGE;
    }

    public static class Serializer<T extends CentrifugeRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"output");
            HashMap<ItemStack, IntArrayNBT> outputs = new HashMap<ItemStack, IntArrayNBT>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                int min = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"min", (int)1);
                int max = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"max", (int)1);
                int chance = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"chance", (int)100);
                IntArrayNBT nbt = new IntArrayNBT(new int[]{min, max, chance});
                if (jsonObject.has("item")) {
                    String registryname = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"item");
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryname));
                    outputs.put(new ItemStack((IItemProvider)item), nbt);
                } else if (jsonObject.has("tag")) {
                    String registryname = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag");
                    Tag tag = ItemTags.func_199903_a().func_199915_b(new ResourceLocation(registryname));
                    if (!tag.func_199885_a().isEmpty()) {
                        outputs.put(new ItemStack((IItemProvider)tag.func_199885_a().stream().findFirst().orElse(Items.field_190931_a)), nbt);
                    }
                }
            });
            return this.factory.create(id, ingredient, outputs);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            HashMap<ItemStack, IntArrayNBT> output = new HashMap<ItemStack, IntArrayNBT>();
            IntStream.range(0, buffer.readInt()).forEach(i -> output.put(buffer.func_150791_c(), new IntArrayNBT(new int[]{buffer.readInt(), buffer.readInt(), buffer.readInt()})));
            return this.factory.create(id, ingredient, output);
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            ((CentrifugeRecipe)recipe).ingredient.func_199564_a(buffer);
            buffer.writeInt(((CentrifugeRecipe)recipe).output.size());
            ((CentrifugeRecipe)recipe).output.forEach((key, value) -> {
                buffer.func_150788_a(key);
                buffer.writeInt(value.get(0).func_150287_d());
                buffer.writeInt(value.get(1).func_150287_d());
                buffer.writeInt(value.get(2).func_150287_d());
            });
        }

        public static interface IRecipeFactory<T extends CentrifugeRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Map<ItemStack, IntArrayNBT> var3);
        }
    }
}

