/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.tileentity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedBeehiveTileEntity
extends AdvancedBeehiveTileEntityAbstract
implements INamedContainerProvider {
    protected int tickCounter = 0;
    private int abandonCountdown = 0;
    protected boolean hasTicked = false;
    public List<String> inhabitantList = new ArrayList<String>();
    protected LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> InventoryHandlerHelper.getInventoryHandler((TileEntity)this, 1));

    public AdvancedBeehiveTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public AdvancedBeehiveTileEntity() {
        this((TileEntityType)ModTileEntityTypes.ADVANCED_BEEHIVE.get());
        this.MAX_BEES = 3;
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new AdvancedBeehiveContainer(windowId, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public boolean func_226972_k_() {
        return true;
    }

    @Override
    public void func_73660_a() {
        BlockState blockState;
        World world = this.field_145850_b;
        if (world == null || world.func_201670_d()) {
            return;
        }
        if (!this.hasTicked && ++this.tickCounter > (Integer)ProductiveBeesConfig.GENERAL.itemTickRate.get()) {
            EntityType beeType;
            BeeEntity newBee;
            this.tickCounter = 0;
            this.productionTick();
            ListNBT beeList = this.getBeeListAsNBTList();
            if (world.func_226690_K_() && ((Boolean)ProductiveBeesConfig.BEES.spawnUndeadBees.get()).booleanValue() && world.field_73012_v.nextDouble() <= (Double)ProductiveBeesConfig.BEES.spawnUndeadBeesChance.get() && beeList.size() + this.beesOutsideHive() < this.MAX_BEES && world.func_201696_r(this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H), 1)) <= 8 && (newBee = (BeeEntity)(beeType = world.field_73012_v.nextBoolean() ? (EntityType)ModEntities.SKELETAL_BEE.get() : (EntityType)ModEntities.ZOMBIE_BEE.get()).func_200721_a(world)) != null) {
                this.func_226961_a_((Entity)newBee, false);
            }
        }
        if (!this.hasTicked && this.tickCounter % 23 == 0 && (blockState = this.func_195044_w()).func_177230_c() instanceof AdvancedBeehive) {
            int honeyLevel = (Integer)blockState.func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
            if (honeyLevel >= 5) {
                int finalHoneyLevel = honeyLevel;
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    ItemStack filledBottle;
                    boolean addedBottle;
                    ItemStack bottles = inv.getStackInSlot(0);
                    if (!bottles.func_190926_b() && (addedBottle = ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(filledBottle = new ItemStack((IItemProvider)Items.field_226638_pX_)))) {
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(new ItemStack((IItemProvider)Items.field_226635_pU_));
                        bottles.func_190918_g(1);
                        world.func_175656_a(this.field_174879_c, (BlockState)blockState.func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(finalHoneyLevel - 5)));
                    }
                });
                honeyLevel = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
            }
            if (((Boolean)blockState.func_177229_b((IProperty)AdvancedBeehive.EXPANDED)).booleanValue() && honeyLevel >= AdvancedBeehiveTileEntity.getMaxHoneyLevel(blockState)) {
                ((AdvancedBeehive)blockState.func_177230_c()).updateState(world, this.func_174877_v(), blockState, false);
            }
        }
        if (--this.abandonCountdown < 0) {
            this.abandonCountdown = 0;
        }
        super.func_73660_a();
        this.hasTicked = false;
    }

    protected void productionTick() {
        ListNBT beeList = this.getBeeListAsNBTList();
        if (beeList.size() > 0) {
            for (INBT inbt : beeList) {
                CompoundNBT inb = (CompoundNBT)((CompoundNBT)inbt).func_74781_a("EntityData");
                String beeId = inb.func_74779_i("id");
                Double productionChance = ProductiveBeeEntity.getProductionChance(beeId, 0.65);
                if (productionChance == null || !(productionChance > 0.0) || !(this.field_145850_b.field_73012_v.nextDouble() <= productionChance)) continue;
                int productivity = inb.func_74764_b("bee_productivity") ? inb.func_74762_e("bee_productivity") : 0;
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> BeeHelper.getBeeProduce(this.field_145850_b, beeId, this.field_226959_b_).forEach(stack -> {
                    if (!stack.func_190926_b()) {
                        if (productivity > 0) {
                            float f = (float)productivity * (float)stack.func_190916_E() * BeeAttributes.productivityModifier.func_186507_b(this.field_145850_b.field_73012_v);
                            stack.func_190917_f(Math.round(f));
                        }
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput((ItemStack)stack);
                    }
                }));
            }
        }
    }

    @Override
    protected void beeReleasePostAction(BeeEntity beeEntity, BlockState state, BeehiveTileEntity.State beeState) {
        super.beeReleasePostAction(beeEntity, state, beeState);
        this.abandonCountdown += this.getTimeInHive(true);
    }

    protected int beesOutsideHive() {
        return (int)Math.ceil(this.abandonCountdown % this.getTimeInHive(true));
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((INBT)invTag));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)inv).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return tag;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

