/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.tileentity;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.handler.bee.InhabitantStorage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AdvancedBeehiveTileEntityAbstract
extends BeehiveTileEntity {
    public BlockPos field_226959_b_ = null;
    public int MAX_BEES = 3;
    private LazyOptional<IInhabitantStorage> beeHandler = LazyOptional.of(this::createBeeHandler);
    private TileEntityType<?> tileEntityType;
    private int tickCounter = 0;

    public AdvancedBeehiveTileEntityAbstract(TileEntityType<?> tileEntityType) {
        this.tileEntityType = tileEntityType;
    }

    @Nonnull
    public TileEntityType<?> func_200662_C() {
        return this.tileEntityType == null ? super.func_200662_C() : this.tileEntityType;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter++ % 100 == 0) {
                this.tickBees();
                this.tickCounter = 0;
            }
            this.beeHandler.ifPresent(h -> {
                if (h.getInhabitants().size() > 0 && this.field_145850_b.func_201674_k().nextDouble() < 0.005) {
                    BlockPos pos = this.func_174877_v();
                    double x = (double)pos.func_177958_n() + 0.5;
                    double y = pos.func_177956_o();
                    double z = (double)pos.func_177952_p() + 0.5;
                    this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_226134_ai_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
    }

    private void tickBees() {
        this.beeHandler.ifPresent(h -> h.getInhabitants().removeIf(inhabitant -> {
            if (inhabitant.ticksInHive > inhabitant.minOccupationTicks) {
                BeehiveTileEntity.State beeState = inhabitant.nbt.func_74767_n("HasNectar") ? BeehiveTileEntity.State.HONEY_DELIVERED : BeehiveTileEntity.State.BEE_RELEASED;
                return this.func_226967_a_(this.func_195044_w(), inhabitant.nbt, null, beeState);
            }
            inhabitant.ticksInHive += this.tickCounter;
            return false;
        }));
    }

    protected int getTimeInHive(boolean hasNectar) {
        return hasNectar ? 2400 : 600;
    }

    public void func_70296_d() {
        if (this.func_226968_d_()) {
            this.func_226963_a_(null, this.field_145850_b.func_180495_p(this.func_174877_v()), BeehiveTileEntity.State.EMERGENCY);
        }
        super.func_70296_d();
    }

    public void func_226963_a_(@Nullable PlayerEntity player, BlockState blockState, BeehiveTileEntity.State beeState) {
        ArrayList releasedBees = Lists.newArrayList();
        this.beeHandler.ifPresent(h -> h.getInhabitants().removeIf(tag -> this.func_226967_a_(blockState, tag.nbt, releasedBees, beeState)));
        if (player != null) {
            for (Entity entity : releasedBees) {
                if (!(entity instanceof BeeEntity)) continue;
                BeeEntity beeEntity = (BeeEntity)entity;
                if (!(player.func_213303_ch().func_72436_e(entity.func_213303_ch()) <= 16.0)) continue;
                if (!this.func_226972_k_()) {
                    beeEntity.func_226391_a_((Entity)player);
                    continue;
                }
                beeEntity.func_226450_t_(400);
            }
        }
    }

    public boolean func_226969_f_() {
        return this.getBeeList().isEmpty();
    }

    public int func_226971_j_() {
        return this.getBeeList().size();
    }

    public boolean func_226970_h_() {
        return this.func_226971_j_() == this.MAX_BEES;
    }

    public void func_226962_a_(Entity entity, boolean hasNectar, int ticksInHive) {
        this.beeHandler.ifPresent(h -> {
            if (h.getInhabitants().size() < this.MAX_BEES) {
                entity.func_184210_p();
                entity.func_184226_ay();
                CompoundNBT compoundNBT = new CompoundNBT();
                entity.func_70039_c(compoundNBT);
                h.addInhabitant(new Inhabitant(compoundNBT, ticksInHive, this.getTimeInHive(hasNectar), entity.func_200200_C_().func_150254_d()));
                if (this.field_145850_b != null) {
                    BeeEntity beeEntity;
                    if (entity instanceof BeeEntity && (beeEntity = (BeeEntity)entity).func_226425_er_() && (!this.hasFlowerPos() || this.field_145850_b.field_73012_v.nextBoolean())) {
                        this.field_226959_b_ = beeEntity.func_226424_eq_();
                    }
                    BlockPos pos = this.func_174877_v();
                    this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                entity.func_70106_y();
            }
        });
    }

    public void func_226961_a_(Entity beeEntity, boolean hasNectar) {
        this.func_226962_a_(beeEntity, hasNectar, 0);
    }

    public boolean func_226967_a_(BlockState state, CompoundNBT tag, @Nullable List<Entity> releasedBees, BeehiveTileEntity.State beeState) {
        boolean stayInside;
        boolean bl = stayInside = this.field_145850_b.field_73011_w.func_76569_d() && this.field_145850_b.func_226690_K_() && tag.func_74762_e("bee_behavior") == 0 || this.field_145850_b.func_72896_J() && (beeState != BeehiveTileEntity.State.EMERGENCY || tag.func_74762_e("bee_weather_tolerance") == 0);
        if (!this.field_145850_b.func_226690_K_() && !this.field_145850_b.func_72896_J() && stayInside) {
            ProductiveBees.LOGGER.info("Bee is staying inside during the day: " + tag);
        }
        if (!stayInside) {
            boolean isPositionBlocked;
            BlockPos pos = this.func_174877_v();
            tag.func_82580_o("Passengers");
            tag.func_82580_o("Leash");
            tag.func_229681_c_("UUID");
            Direction direction = state.func_196959_b((IProperty)BlockStateProperties.field_208155_H) ? (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) : (Direction)state.func_177229_b((IProperty)BeehiveBlock.field_226872_b_);
            BlockPos offset = pos.func_177972_a(direction);
            boolean bl2 = isPositionBlocked = !this.field_145850_b.func_180495_p(offset).func_196952_d((IBlockReader)this.field_145850_b, offset).func_197766_b();
            if (!isPositionBlocked || beeState == BeehiveTileEntity.State.EMERGENCY) {
                boolean spawned = false;
                BeeEntity beeEntity = (BeeEntity)EntityType.func_220335_a((CompoundNBT)tag, (World)this.field_145850_b, spawnedEntity -> spawnedEntity);
                if (beeEntity != null && (spawned = AdvancedBeehiveTileEntityAbstract.spawnBeeInWorldAPosition(this.field_145850_b, beeEntity, pos, direction, null))) {
                    if (this.hasFlowerPos() && !beeEntity.func_226425_er_() && this.field_145850_b.field_73012_v.nextFloat() <= 0.9f) {
                        beeEntity.func_226431_g_(this.field_226959_b_);
                    }
                    this.beeReleasePostAction(beeEntity, state, beeState);
                    if (releasedBees != null) {
                        releasedBees.add((Entity)beeEntity);
                    }
                }
                return spawned;
            }
            return false;
        }
        return false;
    }

    protected void beeReleasePostAction(BeeEntity beeEntity, BlockState state, BeehiveTileEntity.State beeState) {
        beeEntity.func_226426_eu_();
        if (beeState == BeehiveTileEntity.State.HONEY_DELIVERED) {
            int maxHoneyLevel;
            int honeyLevel;
            beeEntity.func_226413_eG_();
            Block block = state.func_177230_c();
            if (state.func_196959_b((IProperty)BeehiveBlock.field_226873_c_) && (honeyLevel = AdvancedBeehiveTileEntityAbstract.func_226964_a_((BlockState)state)) < (maxHoneyLevel = AdvancedBeehiveTileEntityAbstract.getMaxHoneyLevel(state))) {
                int levelIncrease;
                int n = levelIncrease = this.field_145850_b.field_73012_v.nextInt(100) == 0 ? 2 : 1;
                if (honeyLevel + levelIncrease > maxHoneyLevel) {
                    --levelIncrease;
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(honeyLevel + levelIncrease)));
            }
        }
    }

    private boolean hasFlowerPos() {
        return this.field_226959_b_ != null;
    }

    public static int getMaxHoneyLevel(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof AdvancedBeehiveAbstract ? ((AdvancedBeehiveAbstract)block).getMaxHoneyLevel() : 5;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        CompoundNBT beeTag = tag.func_74775_l("Bees");
        this.beeHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)beeTag));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.beeHandler.ifPresent(h -> {
            tag.func_82580_o("Bees");
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("Bees", (INBT)compound);
        });
        return tag;
    }

    @Nonnull
    public ListNBT getBeeListAsNBTList() {
        return (ListNBT)this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitantListAsListNBT).orElse((Object)new ListNBT());
    }

    public static boolean spawnBeeInWorldAPosition(World world, BeeEntity entity, BlockPos pos, Direction direction, @Nullable Integer age) {
        BlockPos offset = pos.func_177972_a(direction);
        boolean isPositionBlocked = !world.func_180495_p(offset).func_196952_d((IBlockReader)world, offset).func_197766_b();
        float width = entity.func_213311_cf();
        double spawnOffset = isPositionBlocked ? 0.0 : 0.55 + (double)(width / 2.0f);
        double x = (double)pos.func_177958_n() + 0.5 + spawnOffset * (double)direction.func_82601_c();
        double y = (double)pos.func_177956_o() + 0.5 - (double)(entity.func_213302_cg() / 2.0f);
        double z = (double)pos.func_177952_p() + 0.5 + spawnOffset * (double)direction.func_82599_e();
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        if (age != null) {
            entity.func_70873_a(age.intValue());
        }
        if (entity.func_200600_R().func_220341_a(EntityTypeTags.field_226155_c_)) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return world.func_217376_c((Entity)entity);
        }
        return false;
    }

    public List<Inhabitant> getBeeList() {
        return (List)this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitants).orElse(new ArrayList());
    }

    private IInhabitantStorage createBeeHandler() {
        return new InhabitantStorage(){

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                AdvancedBeehiveTileEntityAbstract.this.func_70296_d();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBee.BEE) {
            return this.beeHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static class Inhabitant {
        public final CompoundNBT nbt;
        public int ticksInHive;
        public final int minOccupationTicks;
        public final String localizedName;

        public Inhabitant(CompoundNBT nbt, int ticksInHive, int minOccupationTicks, String localizedName) {
            nbt.func_229681_c_("UUID");
            this.nbt = nbt;
            this.ticksInHive = ticksInHive;
            this.minOccupationTicks = minOccupationTicks;
            this.localizedName = localizedName;
        }

        public String toString() {
            return "Bee{ticksInHive=" + this.ticksInHive + ", minOccupationTicks=" + this.minOccupationTicks + ", nbt=" + this.nbt + '}';
        }
    }
}

