/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.tileentity;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.block.Centrifuge;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.tileentity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CentrifugeTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private static final Random rand = new Random();
    private CentrifugeRecipe currentRecipe = null;
    public int recipeProgress = 0;
    private int tankTick = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(12, this){

        @Override
        public boolean isInputItem(Item item) {
            return item == Items.field_151069_bo || item == Items.field_151133_ar || ModTags.HONEYCOMBS.func_199685_a_((Object)item);
        }

        @Override
        public boolean isInputSlotItem(int slot, Item item) {
            return slot == 0 && item == Items.field_151133_ar || slot == 0 && item == Items.field_151069_bo || slot == 1 && ModTags.HONEYCOMBS.func_199685_a_((Object)item);
        }
    });
    public LazyOptional<IFluidHandler> honeyInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CentrifugeTileEntity.this.func_70296_d();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().func_207185_a(ModTags.HONEY);
        }
    });

    public CentrifugeTileEntity() {
        super((TileEntityType)ModTileEntityTypes.CENTRIFUGE.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.inventoryHandler.ifPresent(invHandler -> {
                if (!invHandler.getStackInSlot(1).func_190926_b()) {
                    CentrifugeRecipe recipe = this.getRecipe((IItemHandlerModifiable)invHandler);
                    boolean isValidRecipe = this.canProcessRecipe(recipe, (IItemHandlerModifiable)invHandler);
                    if (isValidRecipe) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                        int totalTime = (Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get();
                        if (++this.recipeProgress == totalTime) {
                            this.recipeProgress = 0;
                            this.completeRecipeProcessing(recipe, (IItemHandlerModifiable)invHandler);
                        }
                    }
                } else {
                    this.recipeProgress = 0;
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
                }
            });
            if (++this.tankTick > 20) {
                this.tankTick = 0;
                this.tickFluidTank();
            }
        }
    }

    private CentrifugeRecipe getRecipe(IItemHandlerModifiable inputHandler) {
        ItemStack input = inputHandler.getStackInSlot(1);
        if (input.func_190926_b() || input == ItemStack.field_190927_a) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.func_77569_a((IInventory)new RecipeWrapper(inputHandler), this.field_145850_b)) {
            return this.currentRecipe;
        }
        this.currentRecipe = this.field_145850_b.func_199532_z().func_215371_a(CentrifugeRecipe.CENTRIFUGE, (IInventory)new RecipeWrapper(inputHandler), this.field_145850_b).orElse(null);
        return this.currentRecipe;
    }

    private boolean canProcessRecipe(@Nullable CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (recipe != null) {
            ArrayList outputList = Lists.newArrayList();
            recipe.output.forEach((key, value) -> {
                ItemStack item = new ItemStack((IItemProvider)key.func_77973_b(), value.get(1).func_150287_d());
                outputList.add(item);
            });
            return ((InventoryHandlerHelper.ItemHandler)invHandler).canFitStacks(outputList);
        }
        return false;
    }

    private void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (this.canProcessRecipe(recipe, invHandler)) {
            this.honeyInventory.ifPresent(honeyHandler -> honeyHandler.fill(new FluidStack((Fluid)ModFluids.HONEY.get(), 250), IFluidHandler.FluidAction.EXECUTE));
            recipe.output.forEach((itemStack, recipeValues) -> {
                if (rand.nextInt(100) <= recipeValues.get(2).func_150287_d()) {
                    int count = MathHelper.func_76136_a((Random)rand, (int)MathHelper.func_76141_d((float)recipeValues.get(0).func_150287_d()), (int)MathHelper.func_76141_d((float)recipeValues.get(1).func_150287_d()));
                    itemStack.func_190920_e(count);
                    ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput((ItemStack)itemStack);
                }
            });
            invHandler.getStackInSlot(1).func_190918_g(1);
        }
        this.recipeProgress = 0;
        this.func_70296_d();
    }

    public void tickFluidTank() {
        this.honeyInventory.ifPresent(honeyHandler -> {
            FluidStack honeyFluid = honeyHandler.getFluidInTank(0);
            if (honeyFluid.getAmount() >= 250) {
                this.inventoryHandler.ifPresent(invHandler -> {
                    ItemStack existingOutput;
                    ItemStack honeyContainerItem = invHandler.getStackInSlot(0);
                    int drainedHoney = 0;
                    ItemStack outputItem = null;
                    if (honeyContainerItem.func_77973_b() == Items.field_151069_bo) {
                        drainedHoney = 250;
                        outputItem = new ItemStack((IItemProvider)Items.field_226638_pX_);
                    } else if (honeyContainerItem.func_77973_b() == Items.field_151133_ar && honeyFluid.getAmount() >= 1000) {
                        drainedHoney = 1000;
                        outputItem = new ItemStack((IItemProvider)ModItems.HONEY_BUCKET.get());
                    }
                    if (drainedHoney > 0 && honeyContainerItem.func_190916_E() > 0 && ((existingOutput = invHandler.getStackInSlot(11)).func_190926_b() || existingOutput.func_77973_b() == outputItem.func_77973_b() && existingOutput.func_190916_E() < outputItem.func_77976_d())) {
                        honeyContainerItem.func_190918_g(1);
                        honeyHandler.drain(drainedHoney, IFluidHandler.FluidAction.EXECUTE);
                        invHandler.insertItem(11, outputItem, false);
                    }
                });
            }
        });
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.inventoryHandler.ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((INBT)invTag));
        CompoundNBT fluidTag = tag.func_74775_l("fluid");
        this.honeyInventory.ifPresent(fluid -> ((INBTSerializable)fluid).deserializeNBT((INBT)fluidTag));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.inventoryHandler.ifPresent(inv -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)inv).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        this.honeyInventory.ifPresent(fluid -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)fluid).serializeNBT();
            tag.func_218657_a("fluid", (INBT)compound);
        });
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.honeyInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.CENTRIFUGE.get()).func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new CentrifugeContainer(windowId, playerInventory, this);
    }
}

