/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.tileentity;

import cy.jdkdigital.productivebees.init.ModTags;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHandlerHelper {
    public static final int BOTTLE_SLOT = 0;
    public static final int INPUT_SLOT = 1;
    public static final int FLUID_ITEM_OUTPUT_SLOT = 11;
    public static final int[] OUTPUT_SLOTS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};

    private static int getAvailableOutputSlot(IItemHandler handler, ItemStack insertStack) {
        return InventoryHandlerHelper.getAvailableOutputSlot(handler, insertStack, new ArrayList<Integer>());
    }

    private static int getAvailableOutputSlot(IItemHandler handler, ItemStack insertStack, List<Integer> blacklistedSlots) {
        int emptySlot = 0;
        for (int slot : OUTPUT_SLOTS) {
            if (blacklistedSlots.contains(slot)) continue;
            ItemStack stack = handler.getStackInSlot(slot);
            int stackSizeLimit = stack.func_77976_d();
            if (stack.func_77973_b() == insertStack.func_77973_b() && stack.func_190916_E() + insertStack.func_190916_E() <= stackSizeLimit) {
                return slot;
            }
            if (!stack.func_190926_b() || emptySlot != 0) continue;
            emptySlot = slot;
        }
        return emptySlot;
    }

    public static ItemHandler getInventoryHandler(TileEntity tileEntity, int inputSize) {
        return new ItemHandler(10 + inputSize, tileEntity);
    }

    public static class FluidHandler
    extends FluidTank
    implements INBTSerializable<CompoundNBT> {
        public FluidHandler(int capacity) {
            super(capacity);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            this.fluid.writeToNBT(nbt);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
        }
    }

    public static class ItemHandler
    extends ItemStackHandler {
        private TileEntity tileEntity;

        public ItemHandler(int size, TileEntity tileEntity) {
            super(size);
            this.tileEntity = tileEntity;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.tileEntity.func_70296_d();
        }

        public boolean isInputSlot(int slot) {
            return slot == 0 || slot == 1;
        }

        public boolean isInputItem(Item item) {
            return item == Items.field_151069_bo;
        }

        public boolean isInputSlotItem(int slot, Item item) {
            return slot == 0 && item == Items.field_151069_bo || slot == 1 && ModTags.HONEYCOMBS.func_199685_a_((Object)item);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.isItemValid(slot, stack, true);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            if (this.isInputSlotItem(slot, stack.func_77973_b())) {
                return true;
            }
            if (this.isInputSlot(slot) && !this.isInputItem(stack.func_77973_b())) {
                return false;
            }
            if (!this.isInputSlot(slot) && !this.isInputItem(stack.func_77973_b())) {
                return true;
            }
            return !fromAutomation;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extractItem(slot, amount, simulate, true);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (fromAutomation && this.isInputSlot(slot)) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.insertItem(slot, stack, simulate, true);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            return super.insertItem(slot, stack, simulate);
        }

        public boolean addOutput(@Nonnull ItemStack stack) {
            int slot = InventoryHandlerHelper.getAvailableOutputSlot((IItemHandler)this, stack);
            if (slot > 0) {
                ItemStack existingStack = this.getStackInSlot(slot);
                if (existingStack.func_190926_b()) {
                    this.setStackInSlot(slot, new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E()));
                } else {
                    existingStack.func_190917_f(stack.func_190916_E());
                }
                this.onContentsChanged(slot);
                return true;
            }
            return false;
        }

        public boolean canFitStacks(List<ItemStack> stacks) {
            ArrayList usedSlots = new ArrayList();
            for (ItemStack stack : stacks) {
                int slot = InventoryHandlerHelper.getAvailableOutputSlot((IItemHandler)this, stack, usedSlots);
                if (slot != 0) continue;
                return false;
            }
            return true;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            int size;
            int n = size = nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size();
            if (size < this.stacks.size()) {
                nbt.func_74768_a("Size", this.stacks.size());
            }
            super.deserializeNBT(nbt);
        }
    }
}

