/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.tileentity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.block.SolitaryNest;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.handler.bee.InhabitantStorage;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.tileentity.AdvancedBeehiveTileEntityAbstract;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SolitaryNestTileEntity
extends AdvancedBeehiveTileEntityAbstract {
    private LazyOptional<IInhabitantStorage> eggHandler = LazyOptional.of(this::createEggHandler);
    protected boolean isSealed = false;
    private int tickCounter = 0;
    private int nestTickTimer = 0;
    public int MAX_EGGS = 3;

    public SolitaryNestTileEntity() {
        super((TileEntityType)ModTileEntityTypes.SOLITARY_NEST.get());
        this.MAX_BEES = 1;
    }

    public boolean isSealed() {
        return this.isSealed;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (++this.nestTickTimer % 47 == 0) {
                if (!this.canRepopulate()) {
                    this.nestTickTimer = 0;
                } else if (this.canRepopulate() && this.nestTickTimer > this.getRepopulationCooldown()) {
                    EntityType<BeeEntity> beeType;
                    this.nestTickTimer = 0;
                    Block block = this.func_195044_w().func_177230_c();
                    if (block instanceof SolitaryNest && (beeType = SolitaryNestTileEntity.getProducibleBeeType(this.field_145850_b, this.field_174879_c, (SolitaryNest)block)) != null) {
                        BeeEntity newBee = (BeeEntity)beeType.func_200721_a(this.field_145850_b);
                        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                        SolitaryNestTileEntity.spawnBeeInWorldAPosition(this.field_145850_b, newBee, this.field_174879_c, direction, null);
                    }
                }
            }
            this.eggHandler.ifPresent(h -> {
                if (h.getInhabitants().isEmpty()) {
                    this.isSealed = false;
                }
            });
            if (this.tickCounter++ % 97 == 0) {
                this.tickEggs();
                this.tickCounter = 0;
            }
        }
        super.func_73660_a();
    }

    private void tickEggs() {
        this.eggHandler.ifPresent(h -> {
            if (h.getInhabitants().isEmpty()) {
                this.isSealed = false;
            }
            if (this.isSealed) {
                h.getInhabitants().removeIf(egg -> {
                    if (egg.ticksInHive > egg.minOccupationTicks) {
                        CompoundNBT tag = egg.nbt;
                        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                        BeeEntity beeEntity = (BeeEntity)EntityType.func_220335_a((CompoundNBT)tag, (World)this.field_145850_b, spawnedEntity -> spawnedEntity);
                        if (beeEntity != null && SolitaryNestTileEntity.spawnBeeInWorldAPosition(this.field_145850_b, beeEntity, this.func_174877_v(), direction, -24000)) {
                            return true;
                        }
                    } else {
                        egg.ticksInHive += this.tickCounter;
                    }
                    return false;
                });
            }
        });
    }

    @Nullable
    public static EntityType<BeeEntity> getProducibleBeeType(World world, BlockPos pos, SolitaryNest nest) {
        EntityType beeType = nest.getNestingBeeType(world);
        if (beeType != null && world.func_201674_k().nextInt(10) == 1) {
            switch (beeType.getRegistryName().func_110623_a()) {
                case "blue_banded_bee": {
                    beeType = (EntityType)ModEntities.NEON_CUCKOO_BEE.get();
                    break;
                }
                case "ashy_mining_bee": {
                    beeType = (EntityType)ModEntities.NOMAD_BEE.get();
                }
            }
        }
        return beeType;
    }

    protected boolean canRepopulate() {
        SolitaryNest nest = (SolitaryNest)this.func_195044_w().func_177230_c();
        boolean blockConditionsMet = nest.canRepopulateIn(this.field_145850_b.func_201675_m(), this.field_145850_b.func_226691_t_(this.func_174877_v()));
        return this.func_226969_f_() && blockConditionsMet;
    }

    protected int getRepopulationCooldown() {
        return (Integer)ProductiveBeesConfig.GENERAL.nestRepopulationCooldown.get();
    }

    @Override
    protected int getTimeInHive(boolean hasNectar) {
        return hasNectar ? 12000 : 600;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        CompoundNBT eggTag = tag.func_74775_l("Eggs");
        this.eggHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)eggTag));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.eggHandler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("Eggs", (INBT)compound);
        });
        return tag;
    }

    @Override
    protected void beeReleasePostAction(BeeEntity beeEntity, BlockState state, BeehiveTileEntity.State beeState) {
        super.beeReleasePostAction(beeEntity, state, beeState);
        if (beeState == BeehiveTileEntity.State.HONEY_DELIVERED) {
            this.eggHandler.ifPresent(h -> {
                if (h.getInhabitants().size() < this.MAX_EGGS) {
                    CompoundNBT compoundNBT = new CompoundNBT();
                    beeEntity.func_70039_c(compoundNBT);
                    h.addInhabitant(new Egg(compoundNBT, 0, this.getRepopulationCooldown() * this.getEggs().size()));
                    if (h.getInhabitants().size() == this.MAX_EGGS) {
                        this.isSealed = true;
                        beeEntity.field_226369_bI_ = null;
                        beeEntity.func_226449_s_(true);
                    }
                }
            });
        }
    }

    public List<AdvancedBeehiveTileEntityAbstract.Inhabitant> getEggs() {
        return (List)this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitants).orElse(new ArrayList());
    }

    @Nonnull
    public ListNBT getEggListAsNBTList() {
        return (ListNBT)this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitantListAsListNBT).orElse((Object)new ListNBT());
    }

    private IInhabitantStorage createEggHandler() {
        return new InhabitantStorage(){

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                SolitaryNestTileEntity.this.func_70296_d();
            }
        };
    }

    public static class Egg
    extends AdvancedBeehiveTileEntityAbstract.Inhabitant {
        public Egg(CompoundNBT nbt, int ticksInHive, int incubationTime) {
            super(nbt, ticksInHive, incubationTime, "");
        }

        @Override
        public String toString() {
            return "Egg {ticksInHive=" + this.ticksInHive + ", incubationTime=" + this.minOccupationTicks + '}';
        }
    }
}

