/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BeeHelper {
    private static final Random rand = new Random();

    public static BeeEntity itemInteract(BeeEntity entity, ItemStack itemStack, World world, CompoundNBT nbt, PlayerEntity player, Hand hand, Direction direction) {
        BlockPos pos = entity.func_180425_c();
        EntityType bee = null;
        if (((Boolean)ProductiveBeesConfig.GENERAL.enableItemConverting.get()).booleanValue()) {
            if (itemStack.func_77973_b() == Items.field_151137_ax) {
                bee = (EntityType)ModEntities.REDSTONE_BEE.get();
            } else if (itemStack.func_77973_b() == Items.field_151166_bC) {
                bee = (EntityType)ModEntities.EMERALD_BEE.get();
            } else if (itemStack.func_77973_b() == Items.field_196128_bn) {
                bee = (EntityType)ModEntities.LAPIS_BEE.get();
            } else if (itemStack.func_77973_b() == Items.field_151045_i) {
                bee = (EntityType)ModEntities.DIAMOND_BEE.get();
            } else if (itemStack.func_77973_b() == Items.field_151042_j) {
                bee = (EntityType)ModEntities.IRON_BEE.get();
            } else if (itemStack.func_77973_b() == Items.field_151043_k) {
                bee = (EntityType)ModEntities.GOLD_BEE.get();
            } else if (itemStack.func_77973_b() == Items.field_226635_pU_) {
                bee = EntityType.field_226289_e_;
            }
        }
        if (itemStack.func_77973_b() == Items.field_221649_bM) {
            bee = (EntityType)ModEntities.CREEPER_BEE.get();
        } else if (itemStack.func_77973_b() == Items.field_221690_bg) {
            bee = (EntityType)ModEntities.WITHER_BEE.get();
        }
        if (bee != null) {
            return BeeHelper.prepareBeeSpawn((EntityType<BeeEntity>)bee, world, nbt, player, pos, direction, entity.func_70874_b());
        }
        return null;
    }

    public static BeeEntity prepareBeeSpawn(EntityType<BeeEntity> beeType, World world, @Nullable CompoundNBT nbt, @Nullable PlayerEntity player, BlockPos pos, Direction direction, int age) {
        BeeEntity bee = (BeeEntity)beeType.func_220349_b(world, nbt, null, player, pos, SpawnReason.CONVERSION, true, true);
        if (bee != null) {
            double x = (double)pos.func_177958_n() + (double)direction.func_82601_c();
            double y = (double)pos.func_177956_o() + 0.5 - (double)(bee.func_213302_cg() / 2.0f);
            double z = (double)pos.func_177952_p() + (double)direction.func_82599_e();
            bee.func_70012_b(x, y, z, bee.field_70177_z, bee.field_70125_A);
            if (age > 0) {
                bee.func_70873_a(age);
            }
            return bee;
        }
        return null;
    }

    public static ResourceLocation getBreedingResult(ProductiveBeeEntity beeEntity, AgeableEntity targetEntity, World world) {
        if (!(targetEntity instanceof ProductiveBeeEntity)) {
            return new ResourceLocation("minecraft:bee");
        }
        if (!beeEntity.getBeeType().equals(((ProductiveBeeEntity)targetEntity).getBeeType())) {
            List recipes = world.func_199532_z().func_215370_b(BeeBreedingRecipe.BEE_BREEDING, (IInventory)new BeeInventory(beeEntity.getBeeType(), ((ProductiveBeeEntity)targetEntity).getBeeType()), world);
            ProductiveBees.LOGGER.info("Recipes::" + recipes);
            if (!recipes.isEmpty()) {
                BeeBreedingRecipe recipe = (BeeBreedingRecipe)recipes.get(rand.nextInt(recipes.size()));
                List<BeeIngredient> possibleOffspring = recipe.offspring;
                if (possibleOffspring != null && possibleOffspring.size() > 0) {
                    return possibleOffspring.get(rand.nextInt(possibleOffspring.size())).getBeeType().getRegistryName();
                }
            }
        }
        return new ResourceLocation("productivebees", beeEntity.getBeeType() + "_bee");
    }

    public static List<ItemStack> getBeeProduce(World world, String beeId, BlockPos flowerPos) {
        AdvancedBeehiveRecipe recipe = world.func_199532_z().func_215371_a(AdvancedBeehiveRecipe.ADVANCED_BEEHIVE, (IInventory)new BeeInventory(beeId), world).orElse(null);
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (recipe != null) {
            recipe.output.forEach((itemStack, bounds) -> {
                int count = MathHelper.func_76136_a((Random)rand, (int)MathHelper.func_76141_d((float)bounds.get(0).func_150287_d()), (int)MathHelper.func_76141_d((float)bounds.get(1).func_150287_d()));
                itemStack.func_190920_e(count);
                outputList.add((ItemStack)itemStack);
            });
            return outputList;
        }
        if (beeId.equals("productivebees:dye_bee")) {
            if (flowerPos != null) {
                BlockState flowerBlock = world.func_180495_p(flowerPos);
                Item flowerItem = Item.func_150898_a((Block)flowerBlock.func_177230_c());
                Map recipes = world.func_199532_z().func_215366_a(IRecipeType.field_222149_a);
                Optional flowerRecipe = recipes.values().stream().flatMap(craftingRecipe -> {
                    AtomicBoolean hasMatchingItem = new AtomicBoolean(false);
                    for (Ingredient ingredient : craftingRecipe.func_192400_c()) {
                        ItemStack[] stacks = ingredient.func_193365_a();
                        if (stacks.length <= 0 || !stacks[0].func_77973_b().equals(flowerItem)) continue;
                        hasMatchingItem.set(true);
                        break;
                    }
                    return Util.func_215081_a(hasMatchingItem.get() ? Optional.of(craftingRecipe) : Optional.empty());
                }).findFirst();
                flowerRecipe.ifPresent(craftingInventoryIRecipe -> {
                    ItemStack dye = new ItemStack((IItemProvider)craftingInventoryIRecipe.func_77571_b().func_77973_b(), 1);
                    outputList.add(dye);
                });
            }
            return outputList;
        }
        return Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
    }

    public static void setOffspringAttributes(ProductiveBeeEntity newBee, ProductiveBeeEntity productiveBeeEntity, AgeableEntity targetEntity) {
        Map<BeeAttribute<?>, Object> attributeMapParent1 = productiveBeeEntity.getBeeAttributes();
        Map<Object, Object> attributeMapParent2 = new HashMap<BeeAttribute<Integer>, Integer>();
        if (targetEntity instanceof ProductiveBeeEntity) {
            attributeMapParent2 = ((ProductiveBeeEntity)targetEntity).getBeeAttributes();
        } else {
            attributeMapParent2.put(BeeAttributes.PRODUCTIVITY, 0);
            attributeMapParent2.put(BeeAttributes.TEMPER, 1);
            attributeMapParent2.put(BeeAttributes.BEHAVIOR, 0);
            attributeMapParent2.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        }
        Map<BeeAttribute<?>, Object> attributeMapChild = newBee.getBeeAttributes();
        int parentProductivity = MathHelper.func_76136_a((Random)rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.PRODUCTIVITY)), (int)((Integer)attributeMapParent2.get(BeeAttributes.PRODUCTIVITY)));
        attributeMapChild.put(BeeAttributes.PRODUCTIVITY, Math.max((Integer)attributeMapChild.get(BeeAttributes.PRODUCTIVITY), parentProductivity));
        int parentTemper = MathHelper.func_76136_a((Random)rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.TEMPER)), (int)((Integer)attributeMapParent2.get(BeeAttributes.TEMPER)));
        attributeMapChild.put(BeeAttributes.TEMPER, Math.max((Integer)attributeMapChild.get(BeeAttributes.TEMPER), parentTemper));
        int parentBehavior = MathHelper.func_76136_a((Random)rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.BEHAVIOR)), (int)((Integer)attributeMapParent2.get(BeeAttributes.BEHAVIOR)));
        attributeMapChild.put(BeeAttributes.BEHAVIOR, Math.max((Integer)attributeMapChild.get(BeeAttributes.BEHAVIOR), parentBehavior));
        int parentWeatherTolerance = MathHelper.func_76136_a((Random)rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.WEATHER_TOLERANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.WEATHER_TOLERANCE)));
        attributeMapChild.put(BeeAttributes.WEATHER_TOLERANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.WEATHER_TOLERANCE), parentWeatherTolerance));
    }

    public static class BeeInventory
    implements IInventory {
        private List<String> beeIdentifiers = new ArrayList<String>();

        public BeeInventory(String beeIdentifier) {
            this.beeIdentifiers.add(beeIdentifier);
        }

        public BeeInventory(String beeIdentifier1, String beeIdentifier2) {
            this.beeIdentifiers.add(beeIdentifier1);
            this.beeIdentifiers.add(beeIdentifier2);
        }

        public String getBeeIdentifier() {
            return this.getBeeIdentifier(0);
        }

        public String getBeeIdentifier(int index) {
            return this.beeIdentifiers.get(index);
        }

        public int func_70302_i_() {
            return 1;
        }

        public boolean func_191420_l() {
            return this.beeIdentifiers.isEmpty();
        }

        @Nonnull
        public ItemStack func_70301_a(int i) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70298_a(int i, int i1) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70304_b(int i) {
            return ItemStack.field_190927_a;
        }

        public void func_70299_a(int i, @Nonnull ItemStack itemStack) {
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(@Nonnull PlayerEntity playerEntity) {
            return false;
        }

        public void func_174888_l() {
            this.beeIdentifiers.clear();
        }
    }
}

