/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import moze_intel.projecte.api.data.ConversionBuilder;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
interface CustomConversionNSSHelper<BUILDER extends ConversionBuilder<BUILDER>> {
    public BUILDER conversion(NormalizedSimpleStack var1, int var2);

    default public BUILDER conversion(NormalizedSimpleStack output) {
        return this.conversion(output, 1);
    }

    default public BUILDER conversion(ItemStack output) {
        return this.conversion(NSSItem.createItem(output), output.func_190916_E());
    }

    default public BUILDER conversion(IItemProvider output) {
        return this.conversion(output, 1);
    }

    default public BUILDER conversion(IItemProvider output, int amount) {
        return this.conversion(NSSItem.createItem(output), amount);
    }

    default public BUILDER conversion(ITag<Item> output) {
        return this.conversion(output, 1);
    }

    default public BUILDER conversion(ITag<Item> output, int amount) {
        return this.conversion(NSSItem.createTag(output), amount);
    }

    default public BUILDER conversion(FluidStack output) {
        return this.conversion(NSSFluid.createFluid(output), output.getAmount());
    }

    default public BUILDER conversion(Fluid output) {
        return this.conversion(output, 1);
    }

    default public BUILDER conversion(Fluid output, int amount) {
        return this.conversion(NSSFluid.createFluid(output), amount);
    }

    default public BUILDER conversionFluid(ITag<Fluid> output) {
        return this.conversionFluid(output, 1);
    }

    default public BUILDER conversionFluid(ITag<Fluid> output, int amount) {
        return this.conversion(NSSFluid.createTag(output), amount);
    }

    default public BUILDER conversion(String fake) {
        return this.conversion(fake, 1);
    }

    default public BUILDER conversion(String fake, int amount) {
        return this.conversion(NSSFake.create(fake), amount);
    }
}

