/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.json.NSSSerializer;

public final class CustomEMCParser {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(NormalizedSimpleStack.class, (Object)NSSSerializer.INSTANCE).setPrettyPrinting().create();
    private static final File CONFIG = ProjectEConfig.CONFIG_DIR.resolve("custom_emc.json").toFile();
    public static CustomEMCFile currentEntries;
    private static boolean dirty;

    public static void init() {
        CustomEMCParser.flush();
        if (!CONFIG.exists()) {
            try {
                if (CONFIG.createNewFile()) {
                    CustomEMCParser.writeDefaultFile();
                }
            }
            catch (IOException e2) {
                PECore.LOGGER.fatal("Exception in file I/O: couldn't create custom configuration files.");
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG));){
            currentEntries = (CustomEMCFile)GSON.fromJson((Reader)reader, CustomEMCFile.class);
            CustomEMCParser.currentEntries.entries.removeIf(e -> !(e.item instanceof NSSItem) || e.emc < 0L);
        }
        catch (JsonParseException | IOException e3) {
            PECore.LOGGER.fatal("Couldn't read custom emc file", e3);
            currentEntries = new CustomEMCFile(new ArrayList<CustomEMCEntry>());
        }
    }

    private static NormalizedSimpleStack getNss(String str) {
        return NSSSerializer.INSTANCE.deserialize(str);
    }

    public static void addToFile(String toAdd, long emc) {
        NormalizedSimpleStack nss = CustomEMCParser.getNss(toAdd);
        CustomEMCEntry entry = new CustomEMCEntry(nss, emc);
        int setAt = -1;
        for (int i = 0; i < CustomEMCParser.currentEntries.entries.size(); ++i) {
            if (!CustomEMCParser.currentEntries.entries.get((int)i).item.equals(nss)) continue;
            setAt = i;
            break;
        }
        if (setAt == -1) {
            CustomEMCParser.currentEntries.entries.add(entry);
        } else {
            CustomEMCParser.currentEntries.entries.set(setAt, entry);
        }
        dirty = true;
    }

    public static boolean removeFromFile(String toRemove) {
        NormalizedSimpleStack nss = CustomEMCParser.getNss(toRemove);
        Iterator<CustomEMCEntry> iter = CustomEMCParser.currentEntries.entries.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            if (!iter.next().item.equals(nss)) continue;
            iter.remove();
            dirty = true;
            removed = true;
        }
        return removed;
    }

    private static void flush() {
        if (dirty) {
            try {
                Files.write((CharSequence)GSON.toJson((Object)currentEntries), (File)CONFIG, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            dirty = false;
        }
    }

    private static void writeDefaultFile() {
        JsonObject elem = (JsonObject)GSON.toJsonTree((Object)new CustomEMCFile(new ArrayList<CustomEMCEntry>()));
        elem.add("__comment", (JsonElement)new JsonPrimitive("Use the in-game commands to edit this file"));
        try {
            Files.write((CharSequence)GSON.toJson((JsonElement)elem), (File)CONFIG, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        dirty = false;
    }

    public static class CustomEMCEntry {
        public final NormalizedSimpleStack item;
        public final long emc;

        private CustomEMCEntry(NormalizedSimpleStack item, long emc) {
            this.item = item;
            this.emc = emc;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CustomEMCEntry && this.item.equals(((CustomEMCEntry)o).item) && this.emc == ((CustomEMCEntry)o).emc;
        }

        public int hashCode() {
            int result = this.item != null ? this.item.hashCode() : 0;
            result = 31 * result + (int)(this.emc ^ this.emc >>> 32);
            return result;
        }
    }

    public static class CustomEMCFile {
        public final List<CustomEMCEntry> entries;

        public CustomEMCFile(List<CustomEMCEntry> entries) {
            this.entries = entries;
        }
    }
}

