/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.config.BasePEConfig;
import moze_intel.projecte.config.IPEConfig;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.config.value.CachedBooleanValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class NBTProcessorConfig
extends BasePEConfig {
    private static NBTProcessorConfig INSTANCE;
    private static final String ENABLED = "enabled";
    private static final String PERSISTENT = "persistent";
    private static final String MAIN_KEY = "processors";
    private final ForgeConfigSpec configSpec;
    private final Map<String, ProcessorConfig> processorConfigs = new HashMap<String, ProcessorConfig>();

    public static void setup(@Nonnull List<INBTProcessor> processors) {
        if (INSTANCE == null) {
            INSTANCE = new NBTProcessorConfig(processors);
            ProjectEConfig.registerConfig(INSTANCE);
        }
    }

    private NBTProcessorConfig(@Nonnull List<INBTProcessor> processors) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(new String[]{"This config is used to control which NBT Processors get used, and which ones actually contribute to the persistent NBT data that gets saved to knowledge/copied in a condenser.", "To disable an NBT Processor set the 'enabled' option for it to false.", "To disable an NBT Processor from contributing to the persistent data set the 'persistent' option for it to false. Note: that if there is no persistent' config option, the NBT Processor never has any persistent data.", "The config options in this file are synced from server to client, as the processors get used dynamically to calculate/preview EMC values for items and are not included in the synced EMC mappings."}).push(MAIN_KEY);
        for (INBTProcessor processor : processors) {
            this.processorConfigs.put(processor.getName(), new ProcessorConfig(this, builder, processor));
        }
        builder.pop();
        this.configSpec = builder.build();
    }

    public static boolean isEnabled(INBTProcessor processor) {
        if (INSTANCE == null) {
            return true;
        }
        String name = processor.getName();
        ProcessorConfig processorConfig = NBTProcessorConfig.INSTANCE.processorConfigs.get(name);
        if (processorConfig == null) {
            PECore.LOGGER.warn("Processor Config: '{}' is missing from the config.", (Object)name);
            return false;
        }
        return processorConfig.enabled.get();
    }

    public static boolean hasPersistent(INBTProcessor processor) {
        if (INSTANCE == null) {
            return false;
        }
        String name = processor.getName();
        ProcessorConfig processorConfig = NBTProcessorConfig.INSTANCE.processorConfigs.get(name);
        if (processorConfig == null) {
            PECore.LOGGER.warn("Processor Config: '{}' is missing from the config.", (Object)name);
            return false;
        }
        if (processorConfig.persistent == null) {
            if (processor.hasPersistentNBT()) {
                PECore.LOGGER.warn("Processor Config: '{}' has persistent NBT but is missing the config option.", (Object)name);
            }
            return false;
        }
        return processorConfig.persistent.get();
    }

    @Override
    public String getFileName() {
        return "processing";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    @Override
    public boolean addToContainer() {
        return false;
    }

    private static class ProcessorConfig {
        public final CachedBooleanValue enabled;
        @Nullable
        public final CachedBooleanValue persistent;

        private ProcessorConfig(IPEConfig config, ForgeConfigSpec.Builder builder, INBTProcessor processor) {
            builder.comment(processor.getDescription()).push(processor.getName());
            this.enabled = CachedBooleanValue.wrap(config, (ForgeConfigSpec.ConfigValue<Boolean>)builder.define(NBTProcessorConfig.ENABLED, processor.isAvailable()));
            this.persistent = processor.hasPersistentNBT() ? CachedBooleanValue.wrap(config, (ForgeConfigSpec.ConfigValue<Boolean>)builder.define(NBTProcessorConfig.PERSISTENT, processor.usePersistentNBT())) : null;
            builder.pop();
        }
    }
}

