/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.network.packets.to_client.SyncFuelMapperPKT;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public final class FuelMapper {
    private static final List<Item> FUEL_MAP = new ArrayList<Item>();
    private static final ResourceLocation FUEL_TAG = PECore.rl("collector_fuel");

    public static void loadMap(ITagCollectionSupplier tagCollectionSupplier) {
        FUEL_MAP.clear();
        ITag collectorFuelTag = tagCollectionSupplier.func_241836_b().func_241834_b(FUEL_TAG);
        collectorFuelTag.func_230236_b_().stream().filter(EMCHelper::doesItemHaveEmc).forEach(FUEL_MAP::add);
        FUEL_MAP.sort(Comparator.comparing(EMCHelper::getEmcValue));
    }

    public static void setFuelMap(List<Item> map) {
        FUEL_MAP.clear();
        FUEL_MAP.addAll(map);
    }

    public static SyncFuelMapperPKT getSyncPacket() {
        return new SyncFuelMapperPKT(FUEL_MAP);
    }

    public static boolean isStackFuel(ItemStack stack) {
        return FUEL_MAP.contains(stack.func_77973_b());
    }

    public static boolean isStackMaxFuel(ItemStack stack) {
        return FUEL_MAP.indexOf(stack.func_77973_b()) == FUEL_MAP.size() - 1;
    }

    public static ItemStack getFuelUpgrade(ItemStack stack) {
        int index = FUEL_MAP.indexOf(stack.func_77973_b());
        if (index == -1) {
            PECore.LOGGER.warn("Tried to upgrade invalid fuel: {}", (Object)stack);
            return ItemStack.field_190927_a;
        }
        int nextIndex = index == FUEL_MAP.size() - 1 ? 0 : index + 1;
        return new ItemStack((IItemProvider)FUEL_MAP.get(nextIndex));
    }

    public static List<Item> getFuelMap() {
        return Collections.unmodifiableList(FUEL_MAP);
    }
}

