/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.events.TickEvents;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.gameObjs.items.armor.PEArmor;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="projecte")
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone evt) {
        evt.getOriginal().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).ifPresent(old -> {
            CompoundNBT bags = (CompoundNBT)old.serializeNBT();
            evt.getPlayer().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).ifPresent(c -> c.deserializeNBT((INBT)bags));
        });
        evt.getOriginal().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(old -> {
            CompoundNBT knowledge = (CompoundNBT)old.serializeNBT();
            evt.getPlayer().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(c -> c.deserializeNBT((INBT)knowledge));
        });
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent evt) {
        evt.getPlayer().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(c -> c.sync((ServerPlayerEntity)evt.getPlayer()));
        evt.getPlayer().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).ifPresent(c -> c.sync(null, (ServerPlayerEntity)evt.getPlayer()));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        event.getPlayer().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(c -> c.sync((ServerPlayerEntity)event.getPlayer()));
        event.getPlayer().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null).ifPresent(c -> c.sync(null, (ServerPlayerEntity)event.getPlayer()));
        event.getPlayer().getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::onDimensionChange);
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)evt.getObject();
            PlayerEvents.attachCapability(evt, AlchBagImpl.Provider.NAME, new AlchBagImpl.Provider());
            PlayerEvents.attachCapability(evt, KnowledgeImpl.Provider.NAME, new KnowledgeImpl.Provider(player));
            if (player instanceof ServerPlayerEntity) {
                PlayerEvents.attachCapability(evt, InternalTimers.NAME, new InternalTimers.Provider());
                PlayerEvents.attachCapability(evt, InternalAbilities.NAME, new InternalAbilities.Provider((ServerPlayerEntity)player));
            }
        }
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> evt, ResourceLocation name, BasicCapabilityResolver<?> cap) {
        evt.addCapability(name, cap);
        evt.addListener(cap::invalidateAll);
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        PacketHandler.sendFragmentedEmcPacket(player);
        player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(knowledge -> {
            knowledge.sync(player);
            PlayerHelper.updateScore(player, PlayerHelper.SCOREBOARD_EMC, knowledge.getEmc());
        });
        player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).ifPresent(c -> c.sync(null, player));
        PECore.debugLog("Sent knowledge and bag data to {}", player.func_200200_C_());
    }

    @SubscribeEvent
    public static void onConstruct(EntityEvent.EntityConstructing evt) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && evt.getEntity() instanceof PlayerEntity && !(evt.getEntity() instanceof FakePlayer)) {
            TransmutationOffline.clear(evt.getEntity().func_110124_au());
            PECore.debugLog("Clearing offline data cache in preparation to load online data", new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onHighAlchemistJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (PECore.uuids.contains(evt.getPlayer().func_110124_au().toString())) {
            IFormattableTextComponent joinMessage = PELang.HIGH_ALCHEMIST.translateColored(TextFormatting.BLUE, TextFormatting.GOLD, evt.getPlayer().func_145748_c_());
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232641_a_((ITextComponent)joinMessage, ChatType.SYSTEM, Util.field_240973_b_);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void pickupItem(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, (NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        if (bag.func_190926_b()) {
            return;
        }
        Optional cap = player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).resolve();
        if (!cap.isPresent()) {
            return;
        }
        IItemHandler handler = ((IAlchBagProvider)cap.get()).getBag(((AlchemicalBag)bag.func_77973_b()).color);
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)event.getItem().func_92059_d(), (boolean)false);
        if (remainder.func_190926_b()) {
            event.getItem().func_70106_y();
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SCollectItemPacket(event.getItem().func_145782_y(), player.func_145782_y(), 1));
        } else {
            event.getItem().func_92058_a(remainder);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent evt) {
        if (evt.getEntity() instanceof ServerPlayerEntity && evt.getSource().func_76347_k() && TickEvents.shouldPlayerResistFire((ServerPlayerEntity)evt.getEntity())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent evt) {
        float damage = evt.getAmount();
        if (damage > 0.0f) {
            float damageAfter;
            DamageSource source;
            LivingEntity entityLiving = evt.getEntityLiving();
            float totalPercentReduced = PlayerEvents.getReductionForSlot(entityLiving, source = evt.getSource(), EquipmentSlotType.HEAD, damage) + PlayerEvents.getReductionForSlot(entityLiving, source, EquipmentSlotType.CHEST, damage) + PlayerEvents.getReductionForSlot(entityLiving, source, EquipmentSlotType.LEGS, damage) + PlayerEvents.getReductionForSlot(entityLiving, source, EquipmentSlotType.FEET, damage);
            float f = damageAfter = totalPercentReduced >= 1.0f ? 0.0f : damage - damage * totalPercentReduced;
            if (damageAfter <= 0.0f) {
                evt.setCanceled(true);
            } else if (damage != damageAfter) {
                evt.setAmount(damageAfter);
            }
        }
    }

    private static float getReductionForSlot(LivingEntity entityLiving, DamageSource source, EquipmentSlotType slot, float damage) {
        ItemStack armorStack = entityLiving.func_184582_a(slot);
        if (armorStack.func_77973_b() instanceof PEArmor) {
            PEArmor armorItem = (PEArmor)armorStack.func_77973_b();
            EquipmentSlotType type = armorItem.func_185083_B_();
            if (type != slot) {
                return 0.0f;
            }
            return Math.max(armorItem.getFullSetBaseReduction(), armorItem.getMaxDamageAbsorb(type, source) / damage) * armorItem.getPieceEffectiveness(type);
        }
        return 0.0f;
    }
}

