/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.gameObjs.blocks.Condenser;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotCondenserLock;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserContainer
extends PEContainer {
    protected final CondenserTile tile;
    public final PEContainer.BoxedLong displayEmc = new PEContainer.BoxedLong();
    public final PEContainer.BoxedLong requiredEmc = new PEContainer.BoxedLong();
    protected final BoxedItemInfo boxedLockInfo = new BoxedItemInfo();

    public CondenserContainer(ContainerTypeRegistryObject<?> type, int windowId, PlayerInventory invPlayer, CondenserTile condenser) {
        super((ContainerType)type.get(), windowId);
        this.longFields.add(this.displayEmc);
        this.longFields.add(this.requiredEmc);
        this.tile = condenser;
        ++this.tile.numPlayersUsing;
        this.initSlots(invPlayer);
    }

    public static CondenserContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        return new CondenserContainer(PEContainerTypes.CONDENSER_CONTAINER, windowId, invPlayer, (CondenserTile)GuiHandler.getTeFromBuf(buf));
    }

    protected void initSlots(PlayerInventory invPlayer) {
        this.func_75146_a(new SlotCondenserLock(this.boxedLockInfo, 0, 12, 6));
        ItemStackHandler handler = this.tile.getInput();
        int counter = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot((IItemHandler)handler, counter++, 12 + j * 18, 26 + i * 18, s -> SlotPredicates.HAS_EMC.test((ItemStack)s) && !this.tile.isStackEqualToLock((ItemStack)s)));
            }
        }
        ContainerHelper.addPlayerInventory(arg_0 -> ((CondenserContainer)this).func_75146_a(arg_0), (IInventory)invPlayer, 48, 154);
    }

    @Override
    public void func_75142_b() {
        this.boxedLockInfo.set(this.tile.getLockInfo());
        this.displayEmc.set(this.tile.displayEmc);
        this.requiredEmc.set(this.tile.requiredEmc);
        if (this.boxedLockInfo.isDirty()) {
            for (IContainerListener listener : this.field_75149_d) {
                PacketHandler.sendLockSlotUpdate(listener, this, this.boxedLockInfo.get());
            }
        }
        super.func_75142_b();
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex <= 91 ? !this.func_75135_a(stack, 92, 127, false) : !EMCHelper.doesItemHaveEmc(stack) || !this.func_75135_a(stack, 1, 91, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, stack);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() instanceof Condenser && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        --this.tile.numPlayersUsing;
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int button, @Nonnull ClickType flag, @Nonnull PlayerEntity player) {
        if (slot == 0) {
            if (this.tile.attemptCondenserSet(player)) {
                this.func_75142_b();
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, button, flag, player);
    }

    public int getProgressScaled() {
        if (this.requiredEmc.get() == 0L) {
            return 0;
        }
        if (this.displayEmc.get() >= this.requiredEmc.get()) {
            return 102;
        }
        return (int)(102.0 * ((double)this.displayEmc.get() / (double)this.requiredEmc.get()));
    }

    public void updateLockInfo(@Nullable ItemInfo lockInfo) {
        this.boxedLockInfo.set(lockInfo);
    }

    public static class BoxedItemInfo {
        @Nullable
        private ItemInfo inner;
        private boolean dirty = false;

        @Nullable
        public ItemInfo get() {
            return this.inner;
        }

        public void set(@Nullable ItemInfo v) {
            if (!Objects.equals(this.inner, v)) {
                this.inner = v;
                this.dirty = true;
            }
        }

        public boolean isDirty() {
            boolean ret = this.dirty;
            this.dirty = false;
            return ret;
        }
    }
}

