/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.math.BigInteger;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotConsume;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotInput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotLock;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotOutput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotUnlearn;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransmutationContainer
extends Container {
    public final TransmutationInventory transmutationInventory;
    private final int blocked;

    public static TransmutationContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        return new TransmutationContainer(windowId, invPlayer, (Hand)buf.func_179257_a(Hand.class));
    }

    public TransmutationContainer(int windowId, PlayerInventory invPlayer, Hand hand) {
        super((ContainerType)PEContainerTypes.TRANSMUTATION_CONTAINER.get(), windowId);
        this.transmutationInventory = new TransmutationInventory(invPlayer.field_70458_d);
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 0, 43, 23));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 1, 34, 41));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 2, 52, 41));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 3, 16, 50));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 4, 70, 50));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 5, 34, 59));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 6, 52, 59));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 7, 43, 77));
        this.func_75146_a((Slot)new SlotLock(this.transmutationInventory, 8, 158, 50));
        this.func_75146_a((Slot)new SlotConsume(this.transmutationInventory, 9, 107, 97));
        this.func_75146_a((Slot)new SlotUnlearn(this.transmutationInventory, 10, 89, 97));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 11, 158, 9));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 12, 176, 13));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 13, 193, 30));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 14, 199, 50));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 15, 193, 70));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 16, 176, 87));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 17, 158, 91));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 18, 140, 87));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 19, 123, 70));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 20, 116, 50));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 21, 123, 30));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 22, 140, 13));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 23, 158, 31));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 24, 177, 50));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 25, 158, 69));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 26, 139, 50));
        ContainerHelper.addPlayerInventory(arg_0 -> ((TransmutationContainer)this).func_75146_a(arg_0), (IInventory)invPlayer, 35, 117);
        this.blocked = hand == Hand.MAIN_HAND ? this.field_75151_b.size() - 1 - (8 - invPlayer.field_70461_c) : -1;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        if (slotIndex <= 7) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex >= 11 && slotIndex <= 26) {
            long itemEmc = EMCHelper.getEmcValue(newStack);
            if (itemEmc > 0L) {
                newStack.func_190920_e(newStack.func_77976_d());
                int stackSize = newStack.func_190916_E() - ItemHelper.simulateFit((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, newStack);
                if (stackSize > 0) {
                    BigInteger availableEMC = this.transmutationInventory.getAvailableEmc();
                    BigInteger emc = BigInteger.valueOf(itemEmc);
                    BigInteger totalEmc = emc.multiply(BigInteger.valueOf(stackSize));
                    if (totalEmc.compareTo(availableEMC) > 0) {
                        BigInteger numOperations = availableEMC.divide(emc);
                        stackSize = numOperations.intValueExact();
                        totalEmc = emc.multiply(numOperations);
                        if (stackSize <= 0) {
                            return ItemStack.field_190927_a;
                        }
                    }
                    newStack.func_190920_e(stackSize);
                    IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
                    if (this.transmutationInventory.isServer()) {
                        this.transmutationInventory.removeEmc(totalEmc);
                    }
                    ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)newStack, (boolean)false);
                }
            }
        } else if (slotIndex > 26) {
            long emc = EMCHelper.getEmcSellValue(stack);
            if (emc == 0L && !(stack.func_77973_b() instanceof Tome)) {
                return ItemStack.field_190927_a;
            }
            if (this.transmutationInventory.isServer()) {
                BigInteger emcBigInt = BigInteger.valueOf(emc);
                this.transmutationInventory.handleKnowledge(newStack);
                this.transmutationInventory.addEmc(emcBigInt.multiply(BigInteger.valueOf(stack.func_190916_E())));
            }
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int dragType, @Nonnull ClickType clickType, @Nonnull PlayerEntity player) {
        if (slot == this.blocked || clickType == ClickType.SWAP && dragType == 40 && this.blocked == -1) {
            return ItemStack.field_190927_a;
        }
        if (player.func_130014_f_().field_72995_K && this.transmutationInventory.getHandlerForSlot(slot) == this.transmutationInventory.outputs) {
            PacketHandler.sendToServer(new SearchUpdatePKT(this.transmutationInventory.getIndexFromSlot(slot), this.func_75139_a(slot).func_75211_c()));
        }
        return super.func_184996_a(slot, dragType, clickType, player);
    }

    public boolean func_94531_b(@Nonnull Slot slot) {
        return !(slot instanceof SlotConsume) && !(slot instanceof SlotUnlearn) && !(slot instanceof SlotInput) && !(slot instanceof SlotLock) && !(slot instanceof SlotOutput);
    }
}

