/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipesCovalenceRepair
extends SpecialRecipe {
    public RecipesCovalenceRepair(ResourceLocation id) {
        super(id);
    }

    @Nullable
    private RepairTargetInfo findIngredients(CraftingInventory inv) {
        ArrayList<ItemStack> dust = new ArrayList<ItemStack>();
        ItemStack tool = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack input = inv.func_70301_a(i);
            if (input.func_190926_b()) continue;
            if (input.func_77973_b().func_206844_a(PETags.Items.COVALENCE_DUST)) {
                dust.add(input);
                continue;
            }
            if (tool.func_190926_b() && ItemHelper.isRepairableDamagedItem(input)) {
                tool = input;
                continue;
            }
            return null;
        }
        if (tool.func_190926_b() || dust.isEmpty()) {
            return null;
        }
        return new RepairTargetInfo(tool, dust.stream().mapToLong(EMCHelper::getEmcValue).sum());
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        RepairTargetInfo targetInfo = this.findIngredients(inv);
        return targetInfo != null && targetInfo.emcPerDurability <= targetInfo.dustEmc;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        RepairTargetInfo targetInfo = this.findIngredients(inv);
        if (targetInfo == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = targetInfo.tool.func_77946_l();
        output.func_196085_b((int)Math.max((long)output.func_77952_i() - targetInfo.dustEmc / targetInfo.emcPerDurability, 0L));
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)PERecipeSerializers.COVALENCE_REPAIR.get();
    }

    private static class RepairTargetInfo {
        private final ItemStack tool;
        private final long emcPerDurability;
        private final long dustEmc;

        public RepairTargetInfo(ItemStack tool, long dustEmc) {
            this.tool = tool;
            this.dustEmc = dustEmc;
            this.emcPerDurability = EMCHelper.getEMCPerDurability(tool);
        }
    }
}

