/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityHomingArrow
extends ArrowEntity {
    private static final DataParameter<Integer> DW_TARGET_ID = EntityDataManager.func_187226_a(EntityHomingArrow.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int NO_TARGET = -1;
    private int newTargetCooldown = 0;

    public EntityHomingArrow(EntityType<EntityHomingArrow> type, World world) {
        super(type, world);
    }

    public EntityHomingArrow(World world, LivingEntity shooter, float damage) {
        super(world, shooter);
        this.func_70239_b(damage);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return (EntityType)PEEntityTypes.HOMING_ARROW.get();
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TARGET_ID, (Object)-1);
    }

    protected void func_184548_a(@Nonnull LivingEntity living) {
        super.func_184548_a(living);
        living.field_70172_ad = 0;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 3) {
            if (this.hasTarget() && (!this.getTarget().func_70089_S() || this.field_70254_i)) {
                this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)-1);
            }
            if (!this.hasTarget() && !this.field_70254_i && this.newTargetCooldown <= 0) {
                this.findNewTarget();
            } else {
                --this.newTargetCooldown;
            }
        }
        if (this.field_70173_aa > 3 && this.hasTarget() && !this.field_70254_i) {
            double mX = this.func_213322_ci().func_82615_a();
            double mY = this.func_213322_ci().func_82617_b();
            double mZ = this.func_213322_ci().func_82616_c();
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + mX / 4.0, this.func_226278_cu_() + mY / 4.0, this.func_226281_cx_() + mZ / 4.0, -mX / 2.0, -mY / 2.0 + 0.2, -mZ / 2.0);
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + mX / 4.0, this.func_226278_cu_() + mY / 4.0, this.func_226281_cx_() + mZ / 4.0, -mX / 2.0, -mY / 2.0 + 0.2, -mZ / 2.0);
            MobEntity target = this.getTarget();
            Vector3d arrowLoc = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            Vector3d targetLoc = new Vector3d(target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_());
            Vector3d lookVec = targetLoc.func_178788_d(arrowLoc);
            Vector3d arrowMotion = new Vector3d(mX, mY, mZ);
            double theta = this.wrap180Radian(this.angleBetween(arrowMotion, lookVec));
            theta = this.clampAbs(theta, 1.5707963267948966);
            Vector3d crossProduct = arrowMotion.func_72431_c(lookVec).func_72432_b();
            Vector3d adjustedLookVec = this.transform(crossProduct, theta, arrowMotion);
            this.func_70186_c(adjustedLookVec.field_72450_a, adjustedLookVec.field_72448_b, adjustedLookVec.field_72449_c, 1.0f, 0.0f);
        }
        super.func_70071_h_();
    }

    private Vector3d transform(Vector3d axis, double angle, Vector3d normal) {
        double m00 = 1.0;
        double m01 = 0.0;
        double m02 = 0.0;
        double m10 = 0.0;
        double m11 = 1.0;
        double m12 = 0.0;
        double m20 = 0.0;
        double m21 = 0.0;
        double m22 = 1.0;
        double mag = Math.sqrt(axis.field_72450_a * axis.field_72450_a + axis.field_72448_b * axis.field_72448_b + axis.field_72449_c * axis.field_72449_c);
        if (mag >= 1.0E-10) {
            mag = 1.0 / mag;
            double ax = axis.field_72450_a * mag;
            double ay = axis.field_72448_b * mag;
            double az = axis.field_72449_c * mag;
            double sinTheta = Math.sin(angle);
            double cosTheta = Math.cos(angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            m00 = t * ax * ax + cosTheta;
            m01 = t * xy - sinTheta * az;
            m02 = t * xz + sinTheta * ay;
            m10 = t * xy + sinTheta * az;
            m11 = t * ay * ay + cosTheta;
            m12 = t * yz - sinTheta * ax;
            m20 = t * xz - sinTheta * ay;
            m21 = t * yz + sinTheta * ax;
            m22 = t * az * az + cosTheta;
        }
        return new Vector3d(m00 * normal.field_72450_a + m01 * normal.field_72448_b + m02 * normal.field_72449_c, m10 * normal.field_72450_a + m11 * normal.field_72448_b + m12 * normal.field_72449_c, m20 * normal.field_72450_a + m21 * normal.field_72448_b + m22 * normal.field_72449_c);
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    private void findNewTarget() {
        List candidates = this.field_70170_p.func_217357_a(MobEntity.class, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
        if (!candidates.isEmpty()) {
            candidates.sort(Comparator.comparing(arg_0 -> ((EntityHomingArrow)this).func_70068_e(arg_0), Double::compare));
            this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)((MobEntity)candidates.get(0)).func_145782_y());
        }
        this.newTargetCooldown = 5;
    }

    private MobEntity getTarget() {
        return (MobEntity)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DW_TARGET_ID)).intValue());
    }

    private boolean hasTarget() {
        return this.getTarget() != null;
    }

    private double angleBetween(Vector3d v1, Vector3d v2) {
        double vDot = v1.func_72430_b(v2) / (v1.func_72433_c() * v2.func_72433_c());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    private double wrap180Radian(double radian) {
        radian %= Math.PI * 2;
        while (radian >= Math.PI) {
            radian -= Math.PI * 2;
        }
        while (radian < -Math.PI) {
            radian += Math.PI * 2;
        }
        return radian;
    }

    private double clampAbs(double param, double maxMagnitude) {
        if (Math.abs(param) > maxMagnitude) {
            param = param < 0.0 ? -Math.abs(maxMagnitude) : Math.abs(maxMagnitude);
        }
        return param;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }
}

