/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.container.EternalDensityContainer;
import moze_intel.projecte.gameObjs.container.inventory.EternalDensityInventory;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class GemEternalDensity
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IItemMode {
    private static final ILangEntry[] modes;

    public GemEternalDensity(Item.Properties props) {
        super(props);
        this.addItemCapability(AlchBagItemCapabilityWrapper::new);
        this.addItemCapability(AlchChestItemCapabilityWrapper::new);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean isHeld) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(inv -> GemEternalDensity.condense(stack, inv));
        }
    }

    private static boolean condense(ItemStack gem, IItemHandler inv) {
        if (!gem.func_196082_o().func_74767_n("Active") || ItemPE.getEmc(gem) >= Long.MAX_VALUE) {
            return false;
        }
        boolean hasChanged = false;
        boolean isWhitelist = ItemHelper.checkItemNBT(gem, "Whitelist");
        List<ItemStack> whitelist = GemEternalDensity.getWhitelist(gem);
        ItemStack target = GemEternalDensity.getTarget(gem);
        for (int i = 0; i < inv.getSlots(); ++i) {
            long emcValue;
            ItemStack s = inv.getStackInSlot(i);
            if (s.func_190926_b() || s.func_77976_d() == 1 || (emcValue = EMCHelper.getEmcValue(s)) <= 0L || emcValue >= EMCHelper.getEmcValue(target) || inv.extractItem(i, s.func_190916_E() == 1 ? 1 : s.func_190916_E() / 2, true).func_190926_b() || (!isWhitelist || !GemEternalDensity.listContains(whitelist, s)) && (isWhitelist || GemEternalDensity.listContains(whitelist, s))) continue;
            ItemStack copy = inv.extractItem(i, s.func_190916_E() == 1 ? 1 : s.func_190916_E() / 2, false);
            GemEternalDensity.addToList(gem, copy);
            ItemPE.addEmcToStack(gem, EMCHelper.getEmcValue(copy) * (long)copy.func_190916_E());
            hasChanged = true;
            break;
        }
        long value = EMCHelper.getEmcValue(target);
        if (!EMCHelper.doesItemHaveEmc(target)) {
            return hasChanged;
        }
        while (GemEternalDensity.getEmc(gem) >= value) {
            ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)target.func_77946_l(), (boolean)false);
            if (!remain.func_190926_b()) {
                return false;
            }
            ItemPE.removeEmc(gem, value);
            GemEternalDensity.setItems(gem, new ArrayList<ItemStack>());
            hasChanged = true;
        }
        return hasChanged;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                CompoundNBT nbt = stack.func_196082_o();
                if (nbt.func_74767_n("Active")) {
                    List<ItemStack> items = GemEternalDensity.getItems(stack);
                    if (!items.isEmpty()) {
                        WorldHelper.createLootDrop(items, world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                        GemEternalDensity.setItems(stack, new ArrayList<ItemStack>());
                        ItemPE.setEmc(stack, 0L);
                    }
                    nbt.func_74757_a("Active", false);
                } else {
                    nbt.func_74757_a("Active", true);
                }
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(stack), buf -> buf.func_150788_a(stack));
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    private static ItemStack getTarget(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (!(item instanceof GemEternalDensity)) {
            PECore.LOGGER.fatal("Invalid gem of eternal density: {}", (Object)stack);
            return ItemStack.field_190927_a;
        }
        byte target = ((GemEternalDensity)item).getMode(stack);
        switch (target) {
            case 0: {
                return new ItemStack((IItemProvider)Items.field_151042_j);
            }
            case 1: {
                return new ItemStack((IItemProvider)Items.field_151043_k);
            }
            case 2: {
                return new ItemStack((IItemProvider)Items.field_151045_i);
            }
            case 3: {
                return new ItemStack(PEItems.DARK_MATTER);
            }
            case 4: {
                return new ItemStack(PEItems.RED_MATTER);
            }
        }
        PECore.LOGGER.fatal("Invalid target for gem of eternal density: {}", (Object)target);
        return ItemStack.field_190927_a;
    }

    private static void setItems(ItemStack stack, List<ItemStack> list) {
        ListNBT tList = new ListNBT();
        for (ItemStack s : list) {
            CompoundNBT nbt = new CompoundNBT();
            s.func_77955_b(nbt);
            tList.add((Object)nbt);
        }
        stack.func_196082_o().func_218657_a("Consumed", (INBT)tList);
    }

    private static List<ItemStack> getItems(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (stack.func_77942_o()) {
            ListNBT tList = stack.func_196082_o().func_150295_c("Consumed", 10);
            for (int i = 0; i < tList.size(); ++i) {
                list.add(ItemStack.func_199557_a((CompoundNBT)tList.func_150305_b(i)));
            }
        }
        return list;
    }

    private static void addToList(ItemStack gem, ItemStack stack) {
        List<ItemStack> list = GemEternalDensity.getItems(gem);
        GemEternalDensity.addToList(list, stack);
        GemEternalDensity.setItems(gem, list);
    }

    private static void addToList(List<ItemStack> list, ItemStack stack) {
        boolean hasFound = false;
        for (ItemStack s : list) {
            if (s.func_190916_E() >= s.func_77976_d() || !ItemHelper.areItemStacksEqual(s, stack)) continue;
            int remain = s.func_77976_d() - s.func_190916_E();
            if (stack.func_190916_E() <= remain) {
                s.func_190917_f(stack.func_190916_E());
                hasFound = true;
                break;
            }
            s.func_190917_f(remain);
            stack.func_190918_g(remain);
        }
        if (!hasFound) {
            list.add(stack);
        }
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        if (stack.func_77973_b() instanceof GemEternalDensity) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null || !nbt.func_150297_b("Consumed", 9)) {
                return nbt;
            }
            return ItemHelper.copyNBTSkipKey(nbt, "Consumed");
        }
        return super.getShareTag(stack);
    }

    private static List<ItemStack> getWhitelist(ItemStack stack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (stack.func_77942_o()) {
            ListNBT list = stack.func_196082_o().func_150295_c("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                result.add(ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i)));
            }
        }
        return result;
    }

    private static boolean listContains(List<ItemStack> list, ItemStack stack) {
        return list.stream().anyMatch(s -> ItemHelper.areItemStacksEqual(s, stack));
    }

    @Override
    public ILangEntry getModeSwitchEntry() {
        return PELang.DENSITY_MODE_TARGET;
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return modes;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.TOOLTIP_GEM_DENSITY_1.translate(new Object[0]));
        if (stack.func_77942_o()) {
            tooltips.add((ITextComponent)PELang.TOOLTIP_GEM_DENSITY_2.translate(this.getModeLangEntry(stack)));
        }
        tooltips.add((ITextComponent)PELang.TOOLTIP_GEM_DENSITY_3.translate(ClientKeyHelper.getKeyName(PEKeybind.MODE)));
        tooltips.add((ITextComponent)PELang.TOOLTIP_GEM_DENSITY_4.translate(new Object[0]));
        tooltips.add((ITextComponent)PELang.TOOLTIP_GEM_DENSITY_5.translate(new Object[0]));
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        AlchChestTile tile;
        if (!world.field_72995_K && ItemHelper.checkItemNBT(stack, "Active") && (tile = WorldHelper.getTileEntity(AlchChestTile.class, (IBlockReader)world, pos, true)) != null) {
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> GemEternalDensity.condense(stack, inv));
            tile.func_70296_d();
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        return !player.func_130014_f_().field_72995_K && GemEternalDensity.condense(stack, inv);
    }

    static {
        ILangEntry[] iLangEntryArray = new ILangEntry[5];
        iLangEntryArray[0] = () -> ((Item)Items.field_151042_j).func_77658_a();
        iLangEntryArray[1] = () -> ((Item)Items.field_151043_k).func_77658_a();
        iLangEntryArray[2] = () -> ((Item)Items.field_151045_i).func_77658_a();
        iLangEntryArray[3] = PEItems.DARK_MATTER::getTranslationKey;
        iLangEntryArray[4] = PEItems.RED_MATTER::getTranslationKey;
        modes = iLangEntryArray;
    }

    private static class ContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;

        private ContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
            return new EternalDensityContainer(windowId, playerInventory, new EternalDensityInventory(this.stack));
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return TextComponentUtil.build(PEItems.GEM_OF_ETERNAL_DENSITY.get());
        }
    }
}

