/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public interface IItemMode
extends IModeChanger {
    public ILangEntry[] getModeLangEntries();

    default public byte getModeCount() {
        return (byte)this.getModeLangEntries().length;
    }

    default public ILangEntry getModeLangEntry(ItemStack stack) {
        ILangEntry[] langEntries = this.getModeLangEntries();
        byte mode = this.getMode(stack);
        if (mode < 0 || mode >= langEntries.length) {
            return PELang.INVALID_MODE;
        }
        return langEntries[mode];
    }

    @Override
    default public byte getMode(@Nonnull ItemStack stack) {
        return stack.func_77942_o() ? stack.func_196082_o().func_74771_c("Mode") : (byte)0;
    }

    @Override
    default public boolean changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        byte numModes = this.getModeCount();
        if (numModes < 2) {
            return false;
        }
        stack.func_196082_o().func_74774_a("Mode", (byte)((this.getMode(stack) + 1) % numModes));
        player.func_145747_a((ITextComponent)this.getModeSwitchEntry().translate(this.getModeLangEntry(stack)), Util.field_240973_b_);
        return true;
    }

    default public ILangEntry getModeSwitchEntry() {
        return PELang.MODE_SWITCH;
    }

    default public ITextComponent getToolTip(ItemStack stack) {
        return PELang.CURRENT_MODE.translate(TextFormatting.AQUA, this.getModeLangEntry(stack));
    }
}

