/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class HarvestGoddess
extends PEToggleItem
implements IPedestalItem {
    public HarvestGoddess(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot >= PlayerInventory.func_70451_h() || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, slot, held);
        PlayerEntity player = (PlayerEntity)entity;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n("Active")) {
            long storedEmc = HarvestGoddess.getEmc(stack);
            if (storedEmc == 0L && !HarvestGoddess.consumeFuel(player, stack, 64L, true)) {
                nbt.func_74757_a("Active", false);
            } else {
                WorldHelper.growNearbyRandomly(true, world, player.func_233580_cy_(), player);
                HarvestGoddess.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.growNearbyRandomly(false, world, player.func_233580_cy_(), player);
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        BlockPos pos = ctx.func_195995_a();
        if (world.field_72995_K || player == null || !player.func_175151_a(pos, ctx.func_196000_l(), ctx.func_195996_i())) {
            return ActionResultType.FAIL;
        }
        if (player.func_225608_bj_()) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b() || stack.func_190916_E() < 4 || stack.func_77973_b() != Items.field_196106_bc) continue;
                if (this.useBoneMeal(world, pos)) {
                    player.field_71071_by.func_70298_a(i, 4);
                    player.field_71069_bz.func_75142_b();
                    return ActionResultType.SUCCESS;
                }
                break;
            }
        } else if (this.plantSeeds(world, player, pos)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private boolean useBoneMeal(World world, BlockPos pos) {
        boolean result = false;
        if (world instanceof ServerWorld) {
            for (BlockPos currentPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-15, 0, -15), (BlockPos)pos.func_177982_a(15, 0, 15))) {
                IGrowable growable;
                BlockState state = world.func_180495_p(currentPos);
                Block crop = state.func_177230_c();
                if (!(crop instanceof IGrowable) || !(growable = (IGrowable)crop).func_176473_a((IBlockReader)world, currentPos, state, false) || !growable.func_180670_a(world, world.field_73012_v, currentPos, state)) continue;
                growable.func_225535_a_((ServerWorld)world, world.field_73012_v, currentPos.func_185334_h(), state);
                if (result) continue;
                result = true;
            }
        }
        return result;
    }

    private boolean plantSeeds(World world, PlayerEntity player, BlockPos pos) {
        List<StackWithSlot> seeds = this.getAllSeeds((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        if (seeds.isEmpty()) {
            return false;
        }
        boolean result = false;
        block0: for (BlockPos currentPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-8, 0, -8), (BlockPos)pos.func_177982_a(8, 0, 8))) {
            if (world.func_175623_d(currentPos)) continue;
            BlockState state = world.func_180495_p(currentPos);
            currentPos = currentPos.func_185334_h();
            for (int i = 0; i < seeds.size(); ++i) {
                StackWithSlot s = seeds.get(i);
                if (!state.canSustainPlant((IBlockReader)world, currentPos, Direction.UP, s.plantable) || !world.func_175623_d(currentPos.func_177984_a())) continue;
                world.func_175656_a(currentPos.func_177984_a(), s.plantable.getPlant((IBlockReader)world, currentPos.func_177984_a()));
                player.field_71071_by.func_70298_a(s.slot, 1);
                player.field_71069_bz.func_75142_b();
                --s.count;
                if (s.count == 0) {
                    seeds.remove(i);
                    if (seeds.isEmpty()) {
                        return true;
                    }
                }
                if (result) continue block0;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private List<StackWithSlot> getAllSeeds(NonNullList<ItemStack> inv) {
        ArrayList<StackWithSlot> result = new ArrayList<StackWithSlot>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (item instanceof IPlantable) {
                result.add(new StackWithSlot(stack, i, (IPlantable)item));
                continue;
            }
            Block block = Block.func_149634_a((Item)item);
            if (!(block instanceof IPlantable)) continue;
            result.add(new StackWithSlot(stack, i, (IPlantable)block));
        }
        return result;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                WorldHelper.growNearbyRandomly(true, world, pos, null);
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.harvest.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_HARVEST_GODDESS_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_HARVEST_GODDESS_2.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_HARVEST_GODDESS_3.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.harvest.get())));
        }
        return list;
    }

    private static class StackWithSlot {
        public final IPlantable plantable;
        public final int slot;
        public int count;

        public StackWithSlot(ItemStack stack, int slot, IPlantable plantable) {
            this.slot = slot;
            this.count = stack.func_190916_E();
            this.plantable = plantable;
        }
    }
}

