/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SWRG
extends ItemPE
implements IPedestalItem,
IFlightProvider,
IProjectileShooter {
    public SWRG(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    private void tick(ItemStack stack, PlayerEntity player) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74762_e("Mode") > 1) {
            WorldHelper.repelEntitiesSWRG(player.func_130014_f_(), player.func_174813_aQ().func_186662_g(5.0), player);
        }
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        if (SWRG.getEmc(stack) == 0L && !SWRG.consumeFuel(player, stack, 64L, false)) {
            if (nbt.func_74762_e("Mode") > 0) {
                this.changeMode(player, stack, 0);
            }
            if (playerMP.field_71075_bZ.field_75101_c) {
                playerMP.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::disableSwrgFlightOverride);
            }
            return;
        }
        if (!playerMP.field_71075_bZ.field_75101_c) {
            playerMP.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::enableSwrgFlightOverride);
        }
        if (playerMP.field_71075_bZ.field_75100_b) {
            if (!this.isFlyingEnabled(nbt)) {
                this.changeMode(player, stack, nbt.func_74762_e("Mode") == 0 ? 1 : 3);
            }
        } else if (this.isFlyingEnabled(nbt)) {
            this.changeMode(player, stack, nbt.func_74762_e("Mode") == 1 ? 0 : 2);
        }
        float toRemove = 0.0f;
        if (playerMP.field_71075_bZ.field_75100_b) {
            toRemove = 0.32f;
        }
        if (nbt.func_74762_e("Mode") == 2) {
            toRemove = 0.32f;
        } else if (nbt.func_74762_e("Mode") == 3) {
            toRemove = 0.64f;
        }
        SWRG.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, toRemove));
        playerMP.field_70143_R = 0.0f;
    }

    private boolean isFlyingEnabled(CompoundNBT nbt) {
        return nbt.func_74762_e("Mode") == 1 || nbt.func_74762_e("Mode") == 3;
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int invSlot, boolean isHeldItem) {
        if (invSlot >= PlayerInventory.func_70451_h() || !(entity instanceof PlayerEntity)) {
            return;
        }
        this.tick(stack, (PlayerEntity)entity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int newMode = 0;
            switch (stack.func_196082_o().func_74762_e("Mode")) {
                case 0: {
                    newMode = 2;
                    break;
                }
                case 1: {
                    newMode = 3;
                    break;
                }
                case 2: {
                    newMode = 0;
                    break;
                }
                case 3: {
                    newMode = 1;
                }
            }
            this.changeMode(player, stack, newMode);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void changeMode(PlayerEntity player, ItemStack stack, int mode) {
        CompoundNBT nbt = stack.func_196082_o();
        int oldMode = nbt.func_74762_e("Mode");
        if (mode == oldMode) {
            return;
        }
        nbt.func_74768_a("Mode", mode);
        if (player == null) {
            return;
        }
        if (mode == 0 || oldMode == 3) {
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.HEAL.get(), SoundCategory.PLAYERS, 0.8f, 1.0f);
        } else if (oldMode == 0 || mode == 3) {
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundCategory.PLAYERS, 0.8f, 1.0f);
        }
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayerEntity player) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() <= 0) {
                List list = world.func_217357_a(MobEntity.class, tile.getEffectBounds());
                for (MobEntity living : list) {
                    LightningBoltEntity lightning;
                    if (living instanceof TameableEntity && ((TameableEntity)living).func_70909_n() || (lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world)) == null) continue;
                    lightning.func_233576_c_(living.func_213303_ch());
                    world.func_217376_c((Entity)lightning);
                }
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.swrg.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_SWRG_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_SWRG_2.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.swrg.get())));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, @Nullable Hand hand) {
        EntitySWRGProjectile projectile = new EntitySWRGProjectile(player, false, player.field_70170_p);
        projectile.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        player.field_70170_p.func_217376_c((Entity)projectile);
        return true;
    }
}

