/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import moze_intel.projecte.capability.managing.SidedItemHandlerResolver;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.EnumCollectorTier;
import moze_intel.projecte.gameObjs.container.CollectorMK1Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PETileEntityTypes;
import moze_intel.projecte.gameObjs.tiles.CapabilityTileEMC;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CollectorMK1Tile
extends CapabilityTileEMC
implements INamedContainerProvider {
    private final ItemStackHandler input = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler auxSlots = new TileEmc.StackHandler(this, 3);
    private final CombinedInvWrapper toSort = new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.auxSlots, 0, 1), this.input});
    public static final int UPGRADING_SLOT = 0;
    public static final int UPGRADE_SLOT = 1;
    public static final int LOCK_SLOT = 2;
    private final long emcGen;
    private boolean hasChargeableItem;
    private boolean hasFuel;
    private long storedFuelEmc;
    private double unprocessedEMC;

    public CollectorMK1Tile() {
        this((TileEntityType)PETileEntityTypes.COLLECTOR.get(), EnumCollectorTier.MK1);
    }

    public CollectorMK1Tile(TileEntityType<?> type, EnumCollectorTier tier) {
        super(type, tier.getStorage());
        this.emcGen = tier.getGenRate();
        this.itemHandlerResolver = new CollectorItemHandlerProvider();
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.hasFuel || this.hasChargeableItem;
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getAux() {
        return this.auxSlots;
    }

    protected int getInvSize() {
        return 8;
    }

    private ItemStack getUpgraded() {
        return this.auxSlots.getStackInSlot(1);
    }

    private ItemStack getLock() {
        return this.auxSlots.getStackInSlot(2);
    }

    private ItemStack getUpgrading() {
        return this.auxSlots.getStackInSlot(0);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ItemHelper.compactInventory((IItemHandlerModifiable)this.toSort);
            this.checkFuelOrKlein();
            this.updateEmc();
            this.rotateUpgraded();
        }
    }

    private void rotateUpgraded() {
        ItemStack upgraded = this.getUpgraded();
        if (!upgraded.func_190926_b() && (this.getLock().func_190926_b() || upgraded.func_77973_b() != this.getLock().func_77973_b() || upgraded.func_190916_E() >= upgraded.func_77976_d())) {
            this.auxSlots.setStackInSlot(1, ItemHandlerHelper.insertItemStacked((IItemHandler)this.input, (ItemStack)upgraded.func_77946_l(), (boolean)false));
        }
    }

    private void checkFuelOrKlein() {
        ItemStack upgrading = this.getUpgrading();
        if (!upgrading.func_190926_b()) {
            Optional emcHolder = upgrading.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
            if (emcHolder.isPresent()) {
                if (((IItemEmcHolder)emcHolder.get()).getNeededEmc(upgrading) > 0L) {
                    this.hasChargeableItem = true;
                    this.hasFuel = false;
                } else {
                    this.hasChargeableItem = false;
                }
            } else {
                this.hasFuel = true;
                this.hasChargeableItem = false;
            }
        } else {
            this.hasFuel = false;
            this.hasChargeableItem = false;
        }
    }

    private void updateEmc() {
        if (!this.hasMaxedEmc()) {
            this.unprocessedEMC += (double)((float)this.emcGen * ((float)this.getSunLevel() / 320.0f));
            if (this.unprocessedEMC >= 1.0) {
                this.unprocessedEMC -= (double)this.forceInsertEmc((long)this.unprocessedEMC, IEmcStorage.EmcAction.EXECUTE);
            }
        }
        if (this.getStoredEmc() > 0L) {
            ItemStack upgrading = this.getUpgrading();
            if (this.hasChargeableItem) {
                upgrading.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(emcHolder -> {
                    long actualInserted = emcHolder.insertEmc(upgrading, Math.min(this.getStoredEmc(), this.emcGen), IEmcStorage.EmcAction.EXECUTE);
                    this.forceExtractEmc(actualInserted, IEmcStorage.EmcAction.EXECUTE);
                });
            } else if (this.hasFuel) {
                ItemStack result;
                long upgradeCost;
                if (FuelMapper.getFuelUpgrade(upgrading).func_190926_b()) {
                    this.auxSlots.setStackInSlot(0, ItemStack.field_190927_a);
                }
                if ((upgradeCost = EMCHelper.getEmcValue(result = this.getLock().func_190926_b() ? FuelMapper.getFuelUpgrade(upgrading) : this.getLock().func_77946_l()) - EMCHelper.getEmcValue(upgrading)) >= 0L && this.getStoredEmc() >= upgradeCost) {
                    ItemStack upgrade = this.getUpgraded();
                    if (this.getUpgraded().func_190926_b()) {
                        this.forceExtractEmc(upgradeCost, IEmcStorage.EmcAction.EXECUTE);
                        this.auxSlots.setStackInSlot(1, result);
                        upgrading.func_190918_g(1);
                    } else if (result.func_77973_b() == upgrade.func_77973_b() && upgrade.func_190916_E() < upgrade.func_77976_d()) {
                        this.forceExtractEmc(upgradeCost, IEmcStorage.EmcAction.EXECUTE);
                        this.getUpgraded().func_190917_f(1);
                        upgrading.func_190918_g(1);
                    }
                }
            } else {
                long toSend = this.getStoredEmc() < this.emcGen ? this.getStoredEmc() : this.emcGen;
                this.sendToAllAcceptors(toSend);
                this.sendRelayBonus();
            }
        }
    }

    public long getEmcToNextGoal() {
        if (!this.getLock().func_190926_b()) {
            return EMCHelper.getEmcValue(this.getLock()) - EMCHelper.getEmcValue(this.getUpgrading());
        }
        return EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(this.getUpgrading())) - EMCHelper.getEmcValue(this.getUpgrading());
    }

    public long getItemCharge() {
        ItemStack upgrading = this.getUpgrading();
        if (!upgrading.func_190926_b()) {
            return upgrading.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).map(emcHolder -> emcHolder.getStoredEmc(upgrading)).orElse(-1L);
        }
        return -1L;
    }

    public double getItemChargeProportion() {
        ItemStack upgrading = this.getUpgrading();
        long charge = this.getItemCharge();
        if (upgrading.func_190926_b() || charge <= 0L) {
            return -1.0;
        }
        Optional emcHolder = upgrading.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (emcHolder.isPresent()) {
            long max = ((IItemEmcHolder)emcHolder.get()).getMaximumEmc(upgrading);
            if (charge >= max) {
                return 1.0;
            }
            return (double)charge / (double)max;
        }
        return -1.0;
    }

    public int getSunLevel() {
        if (this.field_145850_b.func_230315_m_().func_236040_e_()) {
            return 16;
        }
        return this.field_145850_b.func_201696_r(this.field_174879_c.func_177984_a()) + 1;
    }

    public double getFuelProgress() {
        long reqEmc;
        if (this.getUpgrading().func_190926_b() || !FuelMapper.isStackFuel(this.getUpgrading())) {
            return 0.0;
        }
        if (!this.getLock().func_190926_b()) {
            reqEmc = EMCHelper.getEmcValue(this.getLock()) - EMCHelper.getEmcValue(this.getUpgrading());
            if (reqEmc < 0L) {
                return 0.0;
            }
        } else {
            if (FuelMapper.getFuelUpgrade(this.getUpgrading()).func_190926_b()) {
                this.auxSlots.setStackInSlot(0, ItemStack.field_190927_a);
                return 0.0;
            }
            reqEmc = EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(this.getUpgrading())) - EMCHelper.getEmcValue(this.getUpgrading());
        }
        if (this.getStoredEmc() >= reqEmc) {
            return 1.0;
        }
        return (double)this.getStoredEmc() / (double)reqEmc;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.storedFuelEmc = nbt.func_74763_f("FuelEMC");
        this.input.deserializeNBT(nbt.func_74775_l("Input"));
        this.auxSlots.deserializeNBT(nbt.func_74775_l("AuxSlots"));
        this.unprocessedEMC = nbt.func_74769_h("UnprocessedEMC");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74772_a("FuelEMC", this.storedFuelEmc);
        nbt.func_218657_a("Input", (INBT)this.input.serializeNBT());
        nbt.func_218657_a("AuxSlots", (INBT)this.auxSlots.serializeNBT());
        nbt.func_74780_a("UnprocessedEMC", this.unprocessedEMC);
        return nbt;
    }

    private void sendRelayBonus() {
        for (Direction dir : Direction.values()) {
            RelayMK1Tile tile = WorldHelper.getTileEntity(RelayMK1Tile.class, (IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(dir));
            if (tile == null) continue;
            tile.addBonus();
        }
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerIn) {
        return new CollectorMK1Container(windowId, playerInventory, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return TextComponentUtil.build(PEBlocks.COLLECTOR);
    }

    private class CollectorItemHandlerProvider
    extends SidedItemHandlerResolver {
        private final ICapabilityResolver<IItemHandler> automationAuxSlots;
        private final ICapabilityResolver<IItemHandler> automationInput;
        private final ICapabilityResolver<IItemHandler> joined;

        protected CollectorItemHandlerProvider() {
            NonNullLazy automationInput = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)CollectorMK1Tile.this.input, WrappedItemHandler.WriteMode.IN){

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    return SlotPredicates.COLLECTOR_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
                }
            });
            NonNullLazy automationAuxSlots = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)CollectorMK1Tile.this.auxSlots, WrappedItemHandler.WriteMode.OUT){

                @Override
                @Nonnull
                public ItemStack extractItem(int slot, int count, boolean simulate) {
                    if (slot == 1) {
                        return super.extractItem(slot, count, simulate);
                    }
                    return ItemStack.field_190927_a;
                }
            });
            this.automationInput = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)automationInput);
            this.automationAuxSlots = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)automationAuxSlots);
            this.joined = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)automationInput.get(), (IItemHandlerModifiable)automationAuxSlots.get()})));
        }

        @Override
        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction side) {
            if (side == null) {
                return this.joined;
            }
            if (side.func_176740_k().func_200128_b()) {
                return this.automationAuxSlots;
            }
            return this.automationInput;
        }

        @Override
        public void invalidateAll() {
            this.joined.invalidateAll();
            this.automationInput.invalidateAll();
            this.automationAuxSlots.invalidateAll();
        }
    }
}

