/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Random;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.gameObjs.registries.PETileEntityTypes;
import moze_intel.projecte.gameObjs.tiles.CapabilityTileEMC;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class DMPedestalTile
extends CapabilityTileEMC {
    private static final int RANGE = 4;
    private boolean isActive = false;
    private ItemStackHandler inventory = new TileEmc.StackHandler(1){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (DMPedestalTile.this.field_145850_b != null && !((DMPedestalTile)DMPedestalTile.this).field_145850_b.field_72995_K) {
                BlockState state = DMPedestalTile.this.func_195044_w();
                DMPedestalTile.this.field_145850_b.func_184138_a(DMPedestalTile.this.field_174879_c, state, state, 8);
            }
        }
    };
    private int particleCooldown = 10;
    private int activityCooldown = 0;
    public boolean previousRedstoneState = false;
    public double centeredX;
    public double centeredY;
    public double centeredZ;

    public DMPedestalTile() {
        super((TileEntityType)PETileEntityTypes.DARK_MATTER_PEDESTAL.get());
        this.itemHandlerResolver = BasicCapabilityResolver.getBasicItemHandlerResolver((IItemHandler)this.inventory);
    }

    public void func_73660_a() {
        this.centeredX = (double)this.field_174879_c.func_177958_n() + 0.5;
        this.centeredY = (double)this.field_174879_c.func_177956_o() + 0.5;
        this.centeredZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (this.field_145850_b != null && this.getActive()) {
            ItemStack stack = this.inventory.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                stack.getCapability(ProjectEAPI.PEDESTAL_ITEM_CAPABILITY).ifPresent(pedestalItem -> pedestalItem.updateInPedestal(this.field_145850_b, this.field_174879_c));
                if (this.particleCooldown <= 0) {
                    this.spawnParticleTypes();
                    this.particleCooldown = 10;
                } else {
                    --this.particleCooldown;
                }
            } else {
                this.setActive(false);
            }
        }
    }

    private void spawnParticleTypes() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.2, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.2, (double)y + 0.3, (double)z + 0.5, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.2, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.5, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.5, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.8, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.8, (double)y + 0.3, (double)z + 0.5, 0.0, 0.0, 0.0);
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)x + 0.8, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        Random rand = this.field_145850_b.field_73012_v;
        for (int i = 0; i < 3; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5 + 0.25 * (double)j;
            double d1 = (float)this.field_174879_c.func_177956_o() + rand.nextFloat();
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public int getActivityCooldown() {
        return this.activityCooldown;
    }

    public void setActivityCooldown(int i) {
        this.activityCooldown = i;
    }

    public void decrementActivityCooldown() {
        --this.activityCooldown;
    }

    public AxisAlignedBB getEffectBounds() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-4, -4, -4), this.field_174879_c.func_177982_a(4, 4, 4));
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory = new ItemStackHandler(1);
        this.inventory.deserializeNBT(tag);
        this.setActive(tag.func_74767_n("isActive"));
        this.activityCooldown = tag.func_74762_e("activityCooldown");
        this.previousRedstoneState = tag.func_74767_n("powered");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_197643_a(this.inventory.serializeNBT());
        tag.func_74757_a("isActive", this.getActive());
        tag.func_74768_a("activityCooldown", this.activityCooldown);
        tag.func_74757_a("powered", this.previousRedstoneState);
        return tag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void setActive(boolean newState) {
        if (newState != this.getActive() && this.field_145850_b != null) {
            if (newState) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)PESoundEvents.CHARGE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < this.field_145850_b.field_73012_v.nextInt(35) + 10; ++i) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.centeredX + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.13f, (double)(this.field_174879_c.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.13f, this.centeredZ + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
                }
            } else {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < this.field_145850_b.field_73012_v.nextInt(35) + 10; ++i) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.centeredX + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.13f, (double)(this.field_174879_c.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.13f, this.centeredZ + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
                }
            }
        }
        this.isActive = newState;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }
}

