/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import moze_intel.projecte.capability.managing.SidedItemHandlerResolver;
import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.container.RelayMK1Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registries.PETileEntityTypes;
import moze_intel.projecte.gameObjs.tiles.CapabilityTileEMC;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class RelayMK1Tile
extends CapabilityTileEMC
implements INamedContainerProvider {
    private final ItemStackHandler input;
    private final ItemStackHandler output = new TileEmc.StackHandler(this, 1);
    private final long chargeRate;
    private double bonusEMC;

    public RelayMK1Tile() {
        this((TileEntityType)PETileEntityTypes.RELAY.get(), 7, EnumRelayTier.MK1);
    }

    RelayMK1Tile(TileEntityType<?> type, int sizeInv, EnumRelayTier tier) {
        super(type, tier.getStorage());
        this.chargeRate = tier.getChargeRate();
        this.input = new TileEmc.StackHandler(sizeInv){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SlotPredicates.RELAY_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.itemHandlerResolver = new RelayItemHandlerProvider();
    }

    @Override
    public boolean isRelay() {
        return true;
    }

    private ItemStack getCharging() {
        return this.output.getStackInSlot(0);
    }

    private ItemStack getBurn() {
        return this.input.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getOutput() {
        return this.output;
    }

    public void func_73660_a() {
        ItemStack chargeable;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.sendEmc();
        ItemHelper.compactInventory((IItemHandlerModifiable)this.input);
        ItemStack stack = this.getBurn();
        if (!stack.func_190926_b()) {
            Optional holderCapability = stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
            if (holderCapability.isPresent()) {
                IItemEmcHolder emcHolder2 = (IItemEmcHolder)holderCapability.get();
                long simulatedVal = this.forceInsertEmc(emcHolder2.extractEmc(stack, this.chargeRate, IEmcStorage.EmcAction.SIMULATE), IEmcStorage.EmcAction.SIMULATE);
                if (simulatedVal > 0L) {
                    this.forceInsertEmc(emcHolder2.extractEmc(stack, simulatedVal, IEmcStorage.EmcAction.EXECUTE), IEmcStorage.EmcAction.EXECUTE);
                }
            } else {
                long emcVal = EMCHelper.getEmcSellValue(stack);
                if (emcVal > 0L && emcVal <= this.getNeededEmc()) {
                    this.forceInsertEmc(emcVal, IEmcStorage.EmcAction.EXECUTE);
                    this.getBurn().func_190918_g(1);
                }
            }
        }
        if (!(chargeable = this.getCharging()).func_190926_b() && this.getStoredEmc() > 0L) {
            chargeable.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(emcHolder -> {
                long actualSent = emcHolder.insertEmc(chargeable, Math.min(this.getStoredEmc(), this.chargeRate), IEmcStorage.EmcAction.EXECUTE);
                this.forceExtractEmc(actualSent, IEmcStorage.EmcAction.EXECUTE);
            });
        }
    }

    private void sendEmc() {
        if (this.getStoredEmc() == 0L) {
            return;
        }
        if (this.getStoredEmc() <= this.chargeRate) {
            this.sendToAllAcceptors(this.getStoredEmc());
        } else {
            this.sendToAllAcceptors(this.chargeRate);
        }
    }

    public double getItemChargeProportion() {
        Optional holderCapability;
        ItemStack charging = this.getCharging();
        if (!charging.func_190926_b() && (holderCapability = charging.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve()).isPresent()) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
            return (double)emcHolder.getStoredEmc(charging) / (double)emcHolder.getMaximumEmc(charging);
        }
        return 0.0;
    }

    public double getInputBurnProportion() {
        ItemStack burn = this.getBurn();
        if (burn.func_190926_b()) {
            return 0.0;
        }
        Optional holderCapability = burn.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (holderCapability.isPresent()) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
            return (double)emcHolder.getStoredEmc(burn) / (double)emcHolder.getMaximumEmc(burn);
        }
        return (double)burn.func_190916_E() / (double)burn.func_77976_d();
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.input.deserializeNBT(nbt.func_74775_l("Input"));
        this.output.deserializeNBT(nbt.func_74775_l("Output"));
        this.bonusEMC = nbt.func_74769_h("BonusEMC");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_218657_a("Input", (INBT)this.input.serializeNBT());
        nbt.func_218657_a("Output", (INBT)this.output.serializeNBT());
        nbt.func_74780_a("BonusEMC", this.bonusEMC);
        return nbt;
    }

    protected double getBonusToAdd() {
        return 0.05;
    }

    public void addBonus() {
        this.bonusEMC += this.getBonusToAdd();
        if (this.bonusEMC >= 1.0) {
            long emcToInsert = (long)this.bonusEMC;
            this.forceInsertEmc(emcToInsert, IEmcStorage.EmcAction.EXECUTE);
            this.bonusEMC -= (double)emcToInsert;
        }
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new RelayMK1Container(windowId, playerInventory, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return PELang.GUI_RELAY_MK1.translate(new Object[0]);
    }

    private class RelayItemHandlerProvider
    extends SidedItemHandlerResolver {
        private final ICapabilityResolver<IItemHandler> automationOutput;
        private final ICapabilityResolver<IItemHandler> automationInput;
        private final ICapabilityResolver<IItemHandler> joined;

        protected RelayItemHandlerProvider() {
            NonNullLazy automationInput = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)RelayMK1Tile.this.input, WrappedItemHandler.WriteMode.IN));
            NonNullLazy automationOutput = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)RelayMK1Tile.this.output, WrappedItemHandler.WriteMode.IN_OUT){

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    return SlotPredicates.EMC_HOLDER.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
                }

                @Override
                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    Optional holderCapability;
                    ItemStack stack = this.getStackInSlot(slot);
                    if (!stack.func_190926_b() && (holderCapability = stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve()).isPresent()) {
                        IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
                        if (emcHolder.getNeededEmc(stack) == 0L) {
                            return super.extractItem(slot, amount, simulate);
                        }
                        return ItemStack.field_190927_a;
                    }
                    return super.extractItem(slot, amount, simulate);
                }
            });
            this.automationInput = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)automationInput);
            this.automationOutput = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)automationOutput);
            this.joined = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)automationInput.get(), (IItemHandlerModifiable)automationOutput.get()})));
        }

        @Override
        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction side) {
            if (side == null) {
                return this.joined;
            }
            if (side.func_176740_k().func_200128_b()) {
                return this.automationOutput;
            }
            return this.automationInput;
        }

        @Override
        public void invalidateAll() {
            this.joined.invalidateAll();
            this.automationInput.invalidateAll();
            this.automationOutput.invalidateAll();
        }
    }
}

