/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Function;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.network.packets.to_client.CooldownResetPKT;
import moze_intel.projecte.network.packets.to_client.SetFlyPKT;
import moze_intel.projecte.network.packets.to_client.StepHeightPKT;
import moze_intel.projecte.network.packets.to_client.SyncBagDataPKT;
import moze_intel.projecte.network.packets.to_client.SyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.SyncFuelMapperPKT;
import moze_intel.projecte.network.packets.to_client.UpdateCondenserLockPKT;
import moze_intel.projecte.network.packets.to_client.UpdateWindowIntPKT;
import moze_intel.projecte.network.packets.to_client.UpdateWindowLongPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeClearPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import moze_intel.projecte.network.packets.to_server.KeyPressPKT;
import moze_intel.projecte.network.packets.to_server.LeftClickArchangelPKT;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.network.packets.to_server.UpdateGemModePKT;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)PECore.rl("main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int index;

    public static void register() {
        PacketHandler.registerClientToServer(KeyPressPKT.class, KeyPressPKT::decode);
        PacketHandler.registerClientToServer(LeftClickArchangelPKT.class, LeftClickArchangelPKT::decode);
        PacketHandler.registerClientToServer(SearchUpdatePKT.class, SearchUpdatePKT::decode);
        PacketHandler.registerClientToServer(UpdateGemModePKT.class, UpdateGemModePKT::decode);
        PacketHandler.registerServerToClient(CooldownResetPKT.class, CooldownResetPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeClearPKT.class, KnowledgeClearPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncPKT.class, KnowledgeSyncPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncEmcPKT.class, KnowledgeSyncEmcPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncInputsAndLocksPKT.class, KnowledgeSyncInputsAndLocksPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncChangePKT.class, KnowledgeSyncChangePKT::decode);
        PacketHandler.registerServerToClient(SetFlyPKT.class, SetFlyPKT::decode);
        PacketHandler.registerServerToClient(StepHeightPKT.class, StepHeightPKT::decode);
        PacketHandler.registerServerToClient(SyncBagDataPKT.class, SyncBagDataPKT::decode);
        PacketHandler.registerServerToClient(SyncEmcPKT.class, SyncEmcPKT::decode);
        PacketHandler.registerServerToClient(SyncFuelMapperPKT.class, SyncFuelMapperPKT::decode);
        PacketHandler.registerServerToClient(UpdateCondenserLockPKT.class, UpdateCondenserLockPKT::decode);
        PacketHandler.registerServerToClient(UpdateWindowIntPKT.class, UpdateWindowIntPKT::decode);
        PacketHandler.registerServerToClient(UpdateWindowLongPKT.class, UpdateWindowLongPKT::decode);
    }

    private static <MSG extends IPEPacket> void registerClientToServer(Class<MSG> type, Function<PacketBuffer, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG extends IPEPacket> void registerServerToClient(Class<MSG> type, Function<PacketBuffer, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <MSG extends IPEPacket> void registerMessage(Class<MSG> type, Function<PacketBuffer, MSG> decoder, NetworkDirection networkDirection) {
        HANDLER.registerMessage(index++, type, IPEPacket::encode, decoder, IPEPacket::handle, Optional.of(networkDirection));
    }

    public static void sendProgressBarUpdateInt(IContainerListener listener, Container container, int propId, int propVal) {
        if (listener instanceof ServerPlayerEntity) {
            PacketHandler.sendTo(new UpdateWindowIntPKT((short)container.field_75152_c, (short)propId, propVal), (ServerPlayerEntity)listener);
        }
    }

    public static void sendProgressBarUpdateLong(IContainerListener listener, Container container, int propId, long propVal) {
        if (listener instanceof ServerPlayerEntity) {
            PacketHandler.sendTo(new UpdateWindowLongPKT((short)container.field_75152_c, (short)propId, propVal), (ServerPlayerEntity)listener);
        }
    }

    public static void sendLockSlotUpdate(IContainerListener listener, Container container, ItemInfo lockInfo) {
        if (listener instanceof ServerPlayerEntity) {
            PacketHandler.sendTo(new UpdateCondenserLockPKT((short)container.field_75152_c, lockInfo), (ServerPlayerEntity)listener);
        }
    }

    public static <MSG extends IPEPacket> void sendNonLocal(MSG msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_146103_bH().getName().equals(player.field_71133_b.func_71214_G())) {
            PacketHandler.sendTo(msg, player);
        }
    }

    public static void sendFragmentedEmcPacket(ServerPlayerEntity player) {
        PacketHandler.sendNonLocal(new SyncEmcPKT(PacketHandler.serializeEmcData()), player);
        PacketHandler.sendNonLocal(FuelMapper.getSyncPacket(), player);
    }

    public static void sendFragmentedEmcPacketToAll() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            SyncEmcPKT pkt = new SyncEmcPKT(PacketHandler.serializeEmcData());
            SyncFuelMapperPKT fuelPkt = FuelMapper.getSyncPacket();
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                PacketHandler.sendNonLocal(pkt, player);
                PacketHandler.sendNonLocal(fuelPkt, player);
            }
        }
    }

    private static SyncEmcPKT.EmcPKTInfo[] serializeEmcData() {
        SyncEmcPKT.EmcPKTInfo[] data = EMCMappingHandler.createPacketData();
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        int index = buf.writerIndex();
        new SyncEmcPKT(data).encode(buf);
        PECore.debugLog("EMC data size: {} bytes", buf.writerIndex() - index);
        buf.release();
        return data;
    }

    public static <MSG extends IPEPacket> void sendToServer(MSG msg) {
        HANDLER.sendToServer(msg);
    }

    public static <MSG extends IPEPacket> void sendTo(MSG msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            HANDLER.sendTo(msg, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

