/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_client.knowledge;

import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.network.packets.IPEPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class KnowledgeSyncInputsAndLocksPKT
implements IPEPacket {
    private final Map<Integer, ItemStack> stacksToSync;
    private final IKnowledgeProvider.TargetUpdateType updateTargets;

    public KnowledgeSyncInputsAndLocksPKT(Map<Integer, ItemStack> stacksToSync, IKnowledgeProvider.TargetUpdateType updateTargets) {
        this.stacksToSync = stacksToSync;
        this.updateTargets = updateTargets;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(cap -> {
                cap.receiveInputsAndLocks(this.stacksToSync);
                if (this.updateTargets != IKnowledgeProvider.TargetUpdateType.NONE && player.field_71070_bA instanceof TransmutationContainer) {
                    TransmutationInventory transmutationInventory = ((TransmutationContainer)player.field_71070_bA).transmutationInventory;
                    if (this.updateTargets == IKnowledgeProvider.TargetUpdateType.ALL) {
                        transmutationInventory.updateClientTargets();
                    } else {
                        transmutationInventory.checkForUpdates();
                    }
                }
            });
        }
        PECore.debugLog("** RECEIVED TRANSMUTATION INPUT AND LOCK DATA CLIENTSIDE **", new Object[0]);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.stacksToSync.size());
        for (Map.Entry<Integer, ItemStack> entry : this.stacksToSync.entrySet()) {
            buffer.func_150787_b(entry.getKey().intValue());
            buffer.func_150788_a(entry.getValue());
        }
        buffer.func_179249_a((Enum)this.updateTargets);
    }

    public static KnowledgeSyncInputsAndLocksPKT decode(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        HashMap<Integer, ItemStack> syncedStacks = new HashMap<Integer, ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            syncedStacks.put(buffer.func_150792_a(), buffer.func_150791_c());
        }
        return new KnowledgeSyncInputsAndLocksPKT(syncedStacks, (IKnowledgeProvider.TargetUpdateType)buffer.func_179257_a(IKnowledgeProvider.TargetUpdateType.class));
    }
}

