/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.utils.CollectionHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.tags.ITag;
import net.minecraft.world.World;

public class EntityRandomizerHelper {
    public static MobEntity getRandomEntity(World world, MobEntity toRandomize) {
        EntityType entType = toRandomize.func_200600_R();
        if (PETags.Entities.RANDOMIZER_PEACEFUL.func_230235_a_((Object)entType)) {
            return EntityRandomizerHelper.createRandomEntity(world, (Entity)toRandomize, PETags.Entities.RANDOMIZER_PEACEFUL);
        }
        if (PETags.Entities.RANDOMIZER_HOSTILE.func_230235_a_((Object)entType)) {
            MobEntity ent = EntityRandomizerHelper.createRandomEntity(world, (Entity)toRandomize, PETags.Entities.RANDOMIZER_HOSTILE);
            if (ent instanceof RabbitEntity) {
                ((RabbitEntity)ent).func_175529_r(99);
            }
            return ent;
        }
        if (world.field_73012_v.nextBoolean()) {
            return (MobEntity)EntityType.field_200743_ai.func_200721_a(world);
        }
        return (MobEntity)EntityType.field_200737_ac.func_200721_a(world);
    }

    @Nullable
    private static MobEntity createRandomEntity(World world, Entity current, ITag.INamedTag<EntityType<?>> type) {
        EntityType newType;
        EntityType currentType = current.func_200600_R();
        if (currentType == (newType = CollectionHelper.getRandomListEntry(type.func_230236_b_(), currentType))) {
            return null;
        }
        Entity newEntity = newType.func_200721_a(world);
        if (newEntity instanceof MobEntity) {
            return (MobEntity)newEntity;
        }
        if (newEntity != null) {
            newEntity.func_70106_y();
            PECore.LOGGER.warn("Invalid Entity type {} in mob randomizer tag {}. All entities in this tag are expected to be a mob.", (Object)newType.getRegistryName(), (Object)type.func_230234_a_());
        }
        return null;
    }
}

