/*
 * Decompiled with CFR 0.152.
 */
package com.nerdhold.mc.quiver;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.nerdhold.mc.quiver.InventorySlot;
import com.nerdhold.mc.quiver.QuiverItemTypes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_918;

public class QuiverBar {
    public static QuiverBar INSTANCE = new QuiverBar();
    private class_918 _itemRenderer;
    private final class_2960 WIDGETS;
    private static final int _arrowbarSize = 20;
    private static final int _selectionSize = 22;
    private static final int _playerInventoryId = 0;
    private static final int _rightClick = 0;
    private static final int _shiftDown = 0;
    private static final int _offhandIndex = 45;
    private class_310 client = class_310.method_1551();
    List<InventorySlot> arrowStacks;
    List<String> recentChanges = new ArrayList<String>();
    private boolean debugShown = false;
    private final class_327 fontRenderer;

    @Environment(value=EnvType.CLIENT)
    public QuiverBar() {
        this.WIDGETS = new class_2960("textures/gui/widgets.png");
        this._itemRenderer = this.client.method_1480();
        this.fontRenderer = this.client.field_1772;
    }

    @Environment(value=EnvType.CLIENT)
    public void drawQuiverBar() {
        this.arrowStacks = this.getArrowStacks();
        int[] coords = this.getArrowbarCoords(this.arrowStacks.size());
        this.client.method_1531().method_22813(this.WIDGETS);
        for (int i = 0; i < this.arrowStacks.size(); ++i) {
            this.client.field_1705.blit(coords[0], coords[1] + i * 20, 1, 1, 20, 20);
        }
        this.drawStacks(coords, this.arrowStacks);
        this.renderDebugText();
    }

    @Environment(value=EnvType.CLIENT)
    private void drawActiveIndicator(int[] arrowbarCoords, int activeSlot) {
        int[] coords = this.getSlotCoords(arrowbarCoords, activeSlot);
        this.client.method_1531().method_22813(this.WIDGETS);
        this.client.field_1705.blit(coords[0] - 4, coords[1] - 4, 1, 23, 22, 22);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawStacks(int[] arrowbarCoords, List<InventorySlot> itemStacks) {
        RenderSystem.enableRescaleNormal();
        for (int slot = 0; slot < itemStacks.size(); ++slot) {
            class_1799 item = itemStacks.get(slot).getStack();
            if (item == this.client.field_1724.method_6079()) {
                this.drawActiveIndicator(arrowbarCoords, slot);
            }
            int[] itemCoords = this.getSlotCoords(arrowbarCoords, slot);
            this._itemRenderer.method_4023(item, itemCoords[0], itemCoords[1]);
            this._itemRenderer.method_4025(this.client.field_1772, item, itemCoords[0], itemCoords[1]);
        }
        RenderSystem.disableRescaleNormal();
    }

    private int[] getSlotCoords(int[] arrowbarCoords, int slot) {
        int[] coords = new int[]{arrowbarCoords[0] + 3, arrowbarCoords[1] + 3 + slot * 20};
        return coords;
    }

    @Environment(value=EnvType.CLIENT)
    public void switchArrow(int direction) {
        List<InventorySlot> arrowStacks = this.getArrowStacks();
        if (arrowStacks.size() == 0) {
            return;
        }
        int currentStackIndex = -1;
        for (int i = 0; i < arrowStacks.size(); ++i) {
            if (arrowStacks.get(i).getSlot() != 45) continue;
            currentStackIndex = i;
            break;
        }
        int switchToIndex = this.getSwitchToIndex(direction, currentStackIndex, arrowStacks.size());
        InventorySlot switchToStack = arrowStacks.get(switchToIndex);
        int uiIndex = switchToStack.getSlot();
        String debugMessage = MessageFormat.format("About to switch from slot {0} to slot {1} (to inv index {2})", currentStackIndex, switchToIndex, uiIndex);
        if (this.recentChanges.size() > 5) {
            this.recentChanges = this.recentChanges.subList(this.recentChanges.size() - 5, this.recentChanges.size());
        }
        this.recentChanges.add(debugMessage);
        System.out.println(debugMessage);
        if (currentStackIndex != -1) {
            class_1799 currentStack = arrowStacks.get(currentStackIndex).getStack();
            System.out.println(MessageFormat.format("Switching from {0} to {1}", currentStack.method_7964(), switchToStack.getStack().method_7964()));
        } else {
            System.out.println(MessageFormat.format("Switching in {0}", switchToStack.getStack().method_7964()));
        }
        this.client.field_1761.method_2906(0, uiIndex, 0, class_1713.field_7791, (class_1657)this.client.field_1724);
        this.client.field_1761.method_2906(0, 45, 0, class_1713.field_7791, (class_1657)this.client.field_1724);
        this.client.field_1761.method_2906(0, uiIndex, 0, class_1713.field_7791, (class_1657)this.client.field_1724);
    }

    private int getSwitchToIndex(int direction, int currentStackIndex, int size) {
        if (direction == -1 && currentStackIndex == -1) {
            return size - 1;
        }
        int switchToIndex = (currentStackIndex + direction) % size;
        if (switchToIndex < 0) {
            switchToIndex += size;
        }
        return switchToIndex;
    }

    private List<InventorySlot> getArrowStacks() {
        ArrayList<InventorySlot> arrows = new ArrayList<InventorySlot>();
        for (int i = 0; i <= 35; ++i) {
            class_1799 itemStack = this.client.field_1724.field_7514.method_5438(i);
            if (!this.isArrow(itemStack)) continue;
            int uiSlot = i;
            if (uiSlot <= 8) {
                uiSlot += 36;
            }
            arrows.add(new InventorySlot(itemStack, uiSlot));
        }
        class_1799 offhand = this.client.field_1724.method_6079();
        if (this.isArrow(offhand)) {
            arrows.add(new InventorySlot(offhand, 45));
        }
        this.stableSortArrows(arrows);
        return arrows;
    }

    private void stableSortArrows(List<InventorySlot> arrows) {
        arrows.sort((a, b) -> this.getSortKey(b.getStack()).compareTo(this.getSortKey(a.getStack())));
    }

    private String getSortKey(class_1799 item) {
        return item.method_7964().toString() + item.method_7947();
    }

    private boolean isArrow(class_1799 itemStack) {
        return itemStack.method_7909().equals(QuiverItemTypes.arrow) || itemStack.method_7909().equals(QuiverItemTypes.tipped_arrow) || itemStack.method_7909().equals(QuiverItemTypes.spectral_arrow) || itemStack.method_7909().equals(QuiverItemTypes.shield);
    }

    @Environment(value=EnvType.CLIENT)
    private int[] getArrowbarCoords(int itemCount) {
        int[] coords = new int[2];
        coords[0] = 1;
        class_1041 window = this.client.method_22683();
        coords[1] = window.method_4502() / 2;
        int height = itemCount * 20;
        if (coords[1] + height > window.method_4502()) {
            coords[1] = window.method_4502() - height;
        }
        return coords;
    }

    public void toggleDebug() {
        boolean bl = this.debugShown = !this.debugShown;
        if (this.debugShown) {
            System.out.println("Enabling debug display");
        } else {
            System.out.println("Disabling debug display");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void renderDebugText() {
        if (!this.debugShown) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (InventorySlot slot : this.arrowStacks) {
            String name = new class_2585("").method_10852(slot.getStack().method_7964()).method_10863();
            lines.add(MessageFormat.format("{0} of {1} in slot id {2}", slot.getStack().method_7947(), name, slot.getSlot()));
        }
        lines.addAll(this.recentChanges);
        for (int i = 0; i < lines.size(); ++i) {
            String string = (String)lines.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            this.fontRenderer.getClass();
            int j = 9;
            int k = this.fontRenderer.method_1727(string);
            boolean l = false;
            int m = 2 + j * i;
            class_332.fill((int)1, (int)(m - 1), (int)(2 + k + 1), (int)(m + j - 1), (int)-1873784752);
            this.fontRenderer.method_1729(string, 2.0f, (float)m, 0xE0E0E0);
        }
    }
}

