/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.api.dimension;

import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.registries.ChunkGenerators;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.Utils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2794;
import net.minecraft.class_2888;
import net.minecraft.class_2900;
import net.minecraft.class_2906;
import net.minecraft.class_2916;

public enum DimensionChunkGenerators {
    OVERWORLD,
    QUADRUPLE_AMPLIFIED,
    PILLAR_WORLD,
    CUSTOM_OVERWORLD,
    FLOATING,
    LAYERED_FLOATING,
    PRE_CLASSIC_FLOATING,
    CAVE,
    FLAT_CAVES,
    HIGH_CAVES;


    public class_2794<?> getChunkGenerator(class_1937 world, class_1966 biomeSource, DimensionData data, class_2248 stoneBlock) {
        class_2906 config = new class_2906();
        if (Utils.checkBitFlag(data.getFlags(), 32)) {
            config.method_12572(class_2246.field_10164.method_9564());
        }
        if (Utils.checkBitFlag(data.getFlags(), 64)) {
            config.method_12572(class_2246.field_10124.method_9564());
        }
        config.method_12571(stoneBlock.method_9564());
        class_2900 caveConfig = new class_2900();
        caveConfig.method_12571(stoneBlock.method_9564());
        if (Utils.checkBitFlag(data.getFlags(), 32)) {
            caveConfig.method_12572(class_2246.field_10164.method_9564());
        }
        class_2916 floatingConfig = new class_2916();
        floatingConfig.method_12571(stoneBlock.method_9564());
        if (this == CAVE) {
            return ChunkGenerators.CAVES.create(world, biomeSource, (class_2888)caveConfig);
        }
        if (this == FLAT_CAVES) {
            return ChunkGenerators.FLAT_CAVES.create(world, biomeSource, (class_2888)caveConfig);
        }
        if (this == HIGH_CAVES) {
            return ChunkGenerators.HIGH_CAVES.create(world, biomeSource, (class_2888)caveConfig);
        }
        if (this == FLOATING) {
            return ChunkGenerators.FLOATING_ISLANDS.create(world, biomeSource, (class_2888)floatingConfig);
        }
        if (this == LAYERED_FLOATING) {
            return ChunkGenerators.LAYERED_FLOATING.create(world, biomeSource, (class_2888)floatingConfig);
        }
        if (this == PRE_CLASSIC_FLOATING) {
            return ChunkGenerators.PRECLASSIC_FLOATING.create(world, biomeSource, (class_2888)floatingConfig);
        }
        if (this == QUADRUPLE_AMPLIFIED) {
            return ChunkGenerators.QUADRUPLE_AMPLIFIED.create(world, biomeSource, (class_2888)config);
        }
        if (this == PILLAR_WORLD) {
            return ChunkGenerators.PILLAR_WORLD.create(world, biomeSource, (class_2888)config);
        }
        if (this == CUSTOM_OVERWORLD && FabricLoader.getInstance().isModLoaded("simplexterrain")) {
            return ChunkGenerators.CUSTOM_SURFACE.create(world, biomeSource, (class_2888)config);
        }
        if (!FabricLoader.getInstance().isModLoaded("simplexterrain")) {
            data.setDimensionChunkGenerator(Rands.values(DimensionChunkGenerators.values()));
            data.getDimensionChunkGenerator().getChunkGenerator(world, biomeSource, data, stoneBlock);
        }
        return ChunkGenerators.SURFACE.create(world, biomeSource, (class_2888)config);
    }
}

