/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.api.dimension;

import io.github.vampirestudios.raa.blocks.PortalBlock;
import io.github.vampirestudios.raa.generation.dimensions.CustomDimension;
import io.github.vampirestudios.raa.utils.Utils;
import java.util.Objects;
import net.fabricmc.fabric.api.dimension.v1.EntityPlacer;
import net.minecraft.class_1297;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2700;
import net.minecraft.class_3218;

public enum PlayerPlacementHandlers {
    SURFACE_WORLD((teleported, destination, portalDir, horizontalOffset, verticalOffset) -> {
        class_2338 blockPos = PlayerPlacementHandlers.getSurfacePos(destination, teleported, 255);
        destination.method_8501(blockPos.method_10087(1), ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(Objects.requireNonNull(class_2378.field_11155.method_10221((Object)destination.method_8597().method_12460())), "_portal"))).method_9564());
        return new class_2700.class_4297(new class_243((class_2382)blockPos), class_243.field_1353, 0);
    }),
    CAVE_WORLD((teleported, destination, portalDir, horizontalOffset, verticalOffset) -> {
        class_2338 blockPos = PlayerPlacementHandlers.getSurfacePos(destination, teleported, 126);
        destination.method_8501(blockPos.method_10087(1), ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(Objects.requireNonNull(class_2378.field_11155.method_10221((Object)destination.method_8597().method_12460())), "_portal"))).method_9564());
        return new class_2700.class_4297(new class_243((class_2382)blockPos), class_243.field_1353, 0);
    }),
    OVERWORLD((teleported, destination, portalDir, horizontalOffset, verticalOffset) -> {
        class_2338 blockPos = PlayerPlacementHandlers.getSurfacePos(destination, teleported, 255);
        destination.method_8501(blockPos.method_10087(1), ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(Objects.requireNonNull(class_2378.field_11155.method_10221((Object)teleported.method_5770().field_9247.method_12460())), "_portal"))).method_9564());
        return new class_2700.class_4297(new class_243((class_2382)blockPos), class_243.field_1353, 0);
    }),
    FLOATING_WORLD((teleported, destination, portalDir, horizontalOffset, verticalOffset) -> {
        class_2338 blockPos = PlayerPlacementHandlers.getSurfacePos(destination, teleported, 255);
        if (blockPos.method_10264() == 255 || blockPos.method_10264() == 256) {
            blockPos = new class_2338((double)blockPos.method_10263(), teleported.method_23318(), (double)blockPos.method_10260());
            destination.method_8501(blockPos.method_10087(1), ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(Objects.requireNonNull(class_2378.field_11155.method_10221((Object)destination.method_8597().method_12460())), "_portal"))).method_9564());
            class_2680 stone = ((CustomDimension)destination.field_9247).getStoneBlock().method_9564();
            blockPos = blockPos.method_10074();
            destination.method_8501(blockPos.method_10067(), stone);
            destination.method_8501(blockPos.method_10067().method_10095(), stone);
            destination.method_8501(blockPos.method_10095(), stone);
            destination.method_8501(blockPos.method_10095().method_10078(), stone);
            destination.method_8501(blockPos.method_10078(), stone);
            destination.method_8501(blockPos.method_10078().method_10072(), stone);
            destination.method_8501(blockPos.method_10072(), stone);
            destination.method_8501(blockPos.method_10072().method_10067(), stone);
            blockPos = blockPos.method_10074();
            destination.method_8501(blockPos, stone);
            destination.method_8501(blockPos.method_10067(), stone);
            destination.method_8501(blockPos.method_10067().method_10095(), stone);
            destination.method_8501(blockPos.method_10095(), stone);
            destination.method_8501(blockPos.method_10095().method_10078(), stone);
            destination.method_8501(blockPos.method_10078(), stone);
            destination.method_8501(blockPos.method_10078().method_10072(), stone);
            destination.method_8501(blockPos.method_10072(), stone);
            destination.method_8501(blockPos.method_10072().method_10067(), stone);
            return new class_2700.class_4297(new class_243((class_2382)blockPos.method_10086(2)), class_243.field_1353, 0);
        }
        destination.method_8501(blockPos.method_10087(1), ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(Objects.requireNonNull(class_2378.field_11155.method_10221((Object)destination.method_8597().method_12460())), "_portal"))).method_9564());
        return new class_2700.class_4297(new class_243((class_2382)blockPos), class_243.field_1353, 0);
    });

    private EntityPlacer entityPlacer;

    private PlayerPlacementHandlers(EntityPlacer entityPlacer) {
        this.entityPlacer = entityPlacer;
    }

    private static class_2338 getSurfacePos(class_3218 serverWorld, class_1297 entity, int maxHeight) {
        class_2338 portalPos = PlayerPlacementHandlers.getPortalPos(serverWorld, entity, maxHeight);
        if (portalPos != null) {
            return portalPos.method_10084();
        }
        for (int i = maxHeight; i > 0; --i) {
            class_2338 pos = new class_2338(entity.method_5704().method_10263(), i, entity.method_5704().method_10260());
            if (serverWorld.method_8320(pos.method_10087(1)).method_11614() instanceof class_2189 || !(serverWorld.method_8320(pos.method_10084()).method_11614() instanceof class_2189) || !(serverWorld.method_8320(pos).method_11614() instanceof class_2189)) continue;
            return pos.method_10084();
        }
        portalPos = new class_2338(entity.method_5704().method_10263(), maxHeight + 1, entity.method_5704().method_10260());
        serverWorld.method_8501(portalPos.method_10084(), class_2246.field_10124.method_9564());
        serverWorld.method_8501(portalPos, class_2246.field_10124.method_9564());
        return portalPos;
    }

    private static class_2338 getPortalPos(class_3218 serverWorld, class_1297 entity, int maxHeight) {
        for (int i = maxHeight; i > 0; --i) {
            class_2338 pos = new class_2338(entity.method_19538().field_1352, (double)i, entity.method_19538().field_1350);
            if (!(serverWorld.method_8320(pos).method_11614() instanceof PortalBlock)) continue;
            return pos;
        }
        return null;
    }

    public EntityPlacer getEntityPlacer() {
        return this.entityPlacer;
    }
}

