/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.api.namegeneration;

import io.github.vampirestudios.raa.api.namegeneration.INameGenerator;
import io.github.vampirestudios.raa.api.namegeneration.biomes.ChineseBiomes;
import io.github.vampirestudios.raa.api.namegeneration.biomes.EnglishBiomes;
import io.github.vampirestudios.raa.api.namegeneration.biomes.FrenchBiomes;
import io.github.vampirestudios.raa.api.namegeneration.biomes.SpanishBiomes;
import io.github.vampirestudios.raa.api.namegeneration.dimensions.ChineseDimensions;
import io.github.vampirestudios.raa.api.namegeneration.dimensions.EnglishDimensions;
import io.github.vampirestudios.raa.api.namegeneration.dimensions.FrenchDimensions;
import io.github.vampirestudios.raa.api.namegeneration.dimensions.SpanishDimensions;
import io.github.vampirestudios.raa.api.namegeneration.entities.ChineseEntities;
import io.github.vampirestudios.raa.api.namegeneration.entities.EnglishEntities;
import io.github.vampirestudios.raa.api.namegeneration.entities.FrenchEntities;
import io.github.vampirestudios.raa.api.namegeneration.entities.SpanishEntities;
import io.github.vampirestudios.raa.api.namegeneration.material.ChineseMaterials;
import io.github.vampirestudios.raa.api.namegeneration.material.EnglishMaterials;
import io.github.vampirestudios.raa.api.namegeneration.material.FrenchMaterials;
import io.github.vampirestudios.raa.api.namegeneration.material.SpanishMaterials;
import org.apache.commons.lang3.text.WordUtils;

public enum LangEnum {
    ENGLISH(new EnglishMaterials(), new EnglishBiomes(), new EnglishDimensions(), new EnglishEntities()),
    FRENCH(new FrenchMaterials(), new FrenchBiomes(), new FrenchDimensions(), new FrenchEntities()),
    SPANISH(new SpanishMaterials(), new SpanishBiomes(), new SpanishDimensions(), new SpanishEntities()),
    CHINESE(new ChineseMaterials(), new ChineseBiomes(), new ChineseDimensions(), new ChineseEntities());

    private INameGenerator materialNameGenerator;
    private INameGenerator biomeNameGenerator;
    private INameGenerator dimensionNameGenerator;
    private INameGenerator entityNameGenerator;

    private LangEnum(INameGenerator material, INameGenerator biomes, INameGenerator dimensions, INameGenerator entities) {
        this.materialNameGenerator = material;
        this.biomeNameGenerator = biomes;
        this.dimensionNameGenerator = dimensions;
        this.entityNameGenerator = entities;
    }

    public INameGenerator getMaterialNameGenerator() {
        return this.materialNameGenerator;
    }

    public INameGenerator getBiomeNameGenerator() {
        return this.biomeNameGenerator;
    }

    public INameGenerator getDimensionNameGenerator() {
        return this.dimensionNameGenerator;
    }

    public INameGenerator getEntityNameGenerator() {
        return this.entityNameGenerator;
    }

    public String toString() {
        return WordUtils.capitalizeFully((String)this.name());
    }
}

