/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.api.namegeneration.entities;

import io.github.vampirestudios.raa.api.namegeneration.INameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;

public class ChineseEntities
implements INameGenerator {
    public static final String[] PREFIXES = new String[]{"\u6e90", "\u9ad8", "\u5168", "\u53e4", "\u51a0", "\u5178", "\u6377", "\u5eb7", "\u7acb", "\u7f3a", "\u7259", "\u53cd", "\u53c8", "\u81ea", "\u51fa", "\u517c", "\u4f7f", "\u4e0b", "\u5185", "\u6216", "\u8fd1", "\u7f8e", "\u5426", "\u5e03", "\u963b", "\u516c", "\u901a", "\u5ef6", "\u524d", "\u591a", "\u52a0", "\u5c3c", "\u5de1", "\u91cd", "\u6d2a", "\u670b", "\u745f", "\u585e", "\u68ee", "\u661f", "\u7d22", "\u5b50", "\u79d8", "\u8d85", "\u5929", "\u8def", "\u5ddd", "\u5146", "\u5409", "\u6258"};
    public static final String[] MIDDLES = new String[]{"\u5967", "\u963f\u59c6", "\u5b89", "\u6bd4", "\u535a", "\u5361", "\u62ec", "\u5fb7", "\u826f", "\u4f9d", "\u6069", "\u4f5b", "\u4f3d", "\u56e0", "\u5361\u5229", "\u91cc", "\u6d1b", "\u62c9", "\u7c73", "\u62b9", "\u5b5f", "\u637a", "\u4e43", "\u632a", "\u6635", "\u6c83", "\u6b50", "\u73bb", "\u4efb", "\u67d4", "\u745e", "\u897f\u514b", "\u897f", "\u5766", "\u62d3", "\u4e09", "\u56db", "\u6b66", "\u897f", "\u5179"};
    public static final String[] ORE_SUFFIXES = new String[]{"\u59c6", "\u609f\u52d2", "\u6979", "\u6fdb", "\u57c3\u65af", "\u4f0a\u7d20", "\u5076\u7d20", "\u57c3\u52d2", "\u57c3\u7279", "\u5b89\u5fb7", "\u5b89\u7279", "\u5c39", "\u827e\u7d20", "\u514b\u65af"};

    public static void main(String[] args) {
        ChineseEntities gen = new ChineseEntities();
        Collection<String> generated = gen.generate(100);
        System.out.println("Chinese:" + generated);
        ArrayList<String> generated_identifier = new ArrayList<String>();
        Iterator<String> iterator = generated.iterator();
        while (iterator.hasNext()) {
            String s;
            String id = s = iterator.next();
            ChineseEntities entities = new ChineseEntities();
            Map<String, String> specialCharacters = entities.getSpecialCharactersMap();
            SortedMap<String, String> specialCharactersSorted = entities.getSpecialCharactersMapSorted();
            if (specialCharacters != null) {
                for (Map.Entry<String, String> specialCharacter : specialCharacters.entrySet()) {
                    id = id.replace(specialCharacter.getKey(), specialCharacter.getValue());
                }
            }
            if (specialCharactersSorted != null) {
                for (Map.Entry<String, String> specialCharacter : specialCharactersSorted.entrySet()) {
                    id = id.replace(specialCharacter.getKey(), specialCharacter.getValue());
                }
            }
            id = id.toLowerCase(Locale.ENGLISH);
            generated_identifier.add(id);
        }
        System.out.println("Identifier:" + generated_identifier);
        String testVariable = "\u4e0b\u5766\u4f0a\u514b\u65af";
        testVariable = testVariable.replace("\u4f0a\u514b\u65af", "ix");
        System.out.println(testVariable);
    }

    @Override
    public String generate() {
        Random rnd = new Random();
        String ending = "";
        int endingRoll = rnd.nextInt(100);
        if (endingRoll < 30) {
            ending = "\u827e\u7d20";
        } else if (endingRoll < 34) {
            ending = "\u57c3\u53f8";
        } else if (endingRoll < 43) {
            ending = "\u7d20";
        } else if (endingRoll < 69) {
            ending = "\u4f0a\u514b\u65af";
        } else if (endingRoll < 90) {
            ending = "\u4f0a\u7279";
        } else if (endingRoll < 96) {
            ending = ORE_SUFFIXES[rnd.nextInt(ORE_SUFFIXES.length)];
        }
        String prefix = PREFIXES[rnd.nextInt(PREFIXES.length)];
        if (prefix.length() + ending.length() < 5 || prefix.equals("\u8d85") || rnd.nextInt(3) < 2) {
            String middle = MIDDLES[rnd.nextInt(MIDDLES.length)];
            return this.combine(this.combine(prefix, middle), ending);
        }
        return this.combine(prefix, ending);
    }

    public Collection<String> generate(int count) {
        HashSet<String> result = new HashSet<String>(count);
        while (result.size() < count) {
            String cur = this.generate();
            result.add(cur);
        }
        return result;
    }

    public String combine(String a, String b) {
        return a + b;
    }

    @Override
    public SortedMap<String, String> getSpecialCharactersMapSorted() {
        TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                if (a.length() == b.length()) {
                    return 0;
                }
                return a.length() > b.length() ? 1 : -1;
            }
        });
        map.put("\u6e90", "ab");
        map.put("\u9ad8", "ad");
        map.put("\u5168", "ambi");
        map.put("\u53e4", "ante");
        map.put("\u51a0", "circum");
        map.put("\u5178", "co");
        map.put("\u6377", "com");
        map.put("\u5eb7", "con");
        map.put("\u7acb", "contra");
        map.put("\u7f3a", "de");
        map.put("\u7259", "den");
        map.put("\u53cd", "dis");
        map.put("\u53c8", "di");
        map.put("\u81ea", "ex");
        map.put("\u51fa", "extra");
        map.put("\u517c", "in");
        map.put("\u4f7f", "en");
        map.put("\u4e0b", "infra");
        map.put("\u5185", "inter");
        map.put("\u6216", "intra");
        map.put("\u8fd1", "juxta");
        map.put("\u7f8e", "me");
        map.put("\u5426", "ne");
        map.put("\u5e03", "non");
        map.put("\u963b", "ob");
        map.put("\u516c", "ox");
        map.put("\u901a", "per");
        map.put("\u5ef6", "post");
        map.put("\u524d", "prae");
        map.put("\u591a", "preter");
        map.put("\u52a0", "pro");
        map.put("\u5c3c", "quasi");
        map.put("\u5de1", "ques");
        map.put("\u91cd", "re");
        map.put("\u6d2a", "red");
        map.put("\u670b", "retro");
        map.put("\u745f", "se");
        map.put("\u585e", "sed");
        map.put("\u68ee", "sen");
        map.put("\u661f", "sin");
        map.put("\u7d22", "sod");
        map.put("\u5b50", "sub");
        map.put("\u79d8", "subter");
        map.put("\u8d85", "super");
        map.put("\u5929", "supra");
        map.put("\u8def", "tran");
        map.put("\u5ddd", "trans");
        map.put("\u5146", "ult");
        map.put("\u5409", "ultra");
        map.put("\u5916", "out");
        map.put("\u6258", "outr");
        map.put("\u5967", "al");
        map.put("\u963f\u59c6", "am");
        map.put("\u5b89", "an");
        map.put("\u6bd4", "be");
        map.put("\u535a", "bor");
        map.put("\u5361", "cal");
        map.put("\u62ec", "co");
        map.put("\u5fb7", "de");
        map.put("\u826f", "duo");
        map.put("\u4f9d", "eth");
        map.put("\u6069", "en");
        map.put("\u4f5b", "for");
        map.put("\u4f3d", "gal");
        map.put("\u56e0", "in");
        map.put("\u5361\u5229", "kary");
        map.put("\u91cc", "li");
        map.put("\u6d1b", "lo");
        map.put("\u62c9", "la");
        map.put("\u7c73", "mi");
        map.put("\u62b9", "ma");
        map.put("\u5b5f", "mun");
        map.put("\u637a", "nat");
        map.put("\u4e43", "net");
        map.put("\u632a", "nor");
        map.put("\u6635", "nit");
        map.put("\u6c83", "or");
        map.put("\u6b50\u59c6", "om");
        map.put("\u73bb", "per");
        map.put("\u4efb", "rhen");
        map.put("\u67d4", "rho");
        map.put("\u745e", "ri");
        map.put("\u897f\u514b", "sic");
        map.put("\u897f", "sit");
        map.put("\u5766", "tan");
        map.put("\u62d3", "tor");
        map.put("\u4e09", "tri");
        map.put("\u56db", "vi");
        map.put("\u6b66", "w");
        map.put("\u897f", "x");
        map.put("\u5179", "z");
        map.put("\u963f", "a");
        map.put("\u4f0a\u7d20", "ile");
        map.put("\u4f0a\u514b\u65af", "ix");
        map.put("\u4f0a\u7279", "ite");
        map.put("\u4f0a", "i");
        map.put("\u5076", "o");
        map.put("\u5384", "e");
        map.put("\u5df4", "aba");
        map.put("\u8328", "itsi");
        map.put("\u6ecb", "izi");
        map.put("\u4f3a", "isi");
        map.put("\u7f6e", "edge");
        map.put("\u86a9", "ichi");
        map.put("\u4ec0", "ishi");
        map.put("\u73c0", "opo");
        map.put("\u6469", "omo");
        map.put("\u73d0", "afa");
        map.put("\u8fea", "edi");
        map.put("\u631e", "ata");
        map.put("\u56a2", "ana");
        map.put("\u5587", "ala");
        map.put("\u5495", "ugu");
        map.put("\u5580", "aka");
        map.put("\u543d", "oho");
        map.put("\u5df1", "izy");
        map.put("\u7426", "itsi");
        map.put("\u5e0c", "isy");
        map.put("\u59c6", "um");
        map.put("\u609f\u52d2", "ule");
        map.put("\u6979", "ion");
        map.put("\u6fdb", "ment");
        map.put("\u57c3\u65af", "icle");
        map.put("\u5076\u7d20", "ole");
        map.put("\u57c3\u52d2", "ule");
        map.put("\u57c3\u7279", "ate");
        map.put("\u5b89\u5fb7", "and");
        map.put("\u5b89\u7279", "ant");
        map.put("\u5c39", "yn");
        map.put("\u827e\u7d20", "ice");
        map.put("\u514b\u65af", "ixe");
        map.put("\u57c3\u53f8", "ise");
        map.put("\u7d20", "ium");
        return map;
    }

    @Override
    public Map<String, String> getSpecialCharactersMap() {
        return new HashMap<String, String>();
    }
}

