/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class CommandLocateRAAStructure {
    private static List<String> STRUCTURES = Arrays.asList("Tower", "Outpost", "Campfire", "SpiderLair", "Tomb", "Fossil", "PortalHub", "Shrine", "StoneCircle", "BeeNest", "UndergroundBeeNest", "CaveCampfire", "MushroomRuin");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode basenode = dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"locateRAA").then(class_2170.method_9244((String)"RAAstructure", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandLocateRAAStructure.suggestedStrings()).executes(ctx -> CommandLocateRAAStructure.locateStructure((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"RAAstructure")))));
    }

    private static int locateStructure(class_2168 source, String structureName) {
        int found = -1;
        float distance = -1.0f;
        List<Integer> spawnPos = Arrays.asList(0, 0, 0);
        try {
            if (!STRUCTURES.contains(structureName)) {
                found = 0;
                throw new SimpleCommandExceptionType((Message)new class_2588("structure.notfound", new Object[]{structureName})).create();
            }
            String worldPath = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? "saves/" + source.method_9225().method_17982().method_132().getName() : source.method_9225().method_8401().method_150();
            String spawnPath = worldPath + "/DIM_raa_" + source.method_9225().method_8597().method_12460().method_12489().substring(4) + "/data/";
            if (structureName.equals("PortalHub") && source.method_9225().method_8597().method_12460().method_12489().equals("")) {
                spawnPath = worldPath + "/data/portal_hub_spawns.txt";
            } else if (structureName.equals("Tower") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "tower_spawns.txt";
            } else if (structureName.equals("Outpost") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "outpost_spawns.txt";
            } else if (structureName.equals("Campfire") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "campfire_spawns.txt";
            } else if (structureName.equals("SpiderLair") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "spider_lair_spawns.txt";
            } else if (structureName.equals("Tomb") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "tomb_spawns.txt";
            } else if (structureName.equals("Fossil") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "fossil_spawns.txt";
            } else if (structureName.equals("Shrine") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "shrine_spawns.txt";
            } else if (structureName.equals("StoneCircle") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "stone_circle_spawns.txt";
            } else if (structureName.equals("BeeNest") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "bee_nest_spawns.txt";
            } else if (structureName.equals("UndergroundBeeNest") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "underground_bee_hive_spawns.txt";
            } else if (structureName.equals("CaveCampfire") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "cave_campfire_spawns.txt";
            } else if (structureName.equals("MushroomRuin") && CommandLocateRAAStructure.isRaaDimension(source)) {
                spawnPath = spawnPath + "mushruin_spawns.txt";
            } else {
                throw new SimpleCommandExceptionType((Message)new class_2588("structure.notfound", new Object[]{structureName})).create();
            }
            BufferedReader reader = new BufferedReader(new FileReader(spawnPath));
            String spawn = reader.readLine();
            while (spawn != null) {
                float spawnDistance = (float)Math.sqrt(Math.pow(source.method_9222().field_1352 - (double)Integer.parseInt(spawn.split(",")[0]), 2.0) + Math.pow(source.method_9222().field_1351 - (double)Integer.parseInt(spawn.split(",")[1]), 2.0) + Math.pow(source.method_9222().field_1350 - (double)Integer.parseInt(spawn.split(",")[2]), 2.0));
                if (distance == -1.0f || spawnDistance < distance) {
                    distance = spawnDistance;
                    String[] coords = spawn.split(",");
                    spawnPos.set(0, Integer.parseInt(coords[0]));
                    spawnPos.set(1, Integer.parseInt(coords[1]));
                    spawnPos.set(2, Integer.parseInt(coords[2]));
                    found = 1;
                }
                spawn = reader.readLine();
            }
            if (found == -1) {
                throw new SimpleCommandExceptionType((Message)new class_2588("structure.notfound", new Object[]{structureName})).create();
            }
        }
        catch (CommandSyntaxException | IOException e) {
            e.printStackTrace();
        }
        if (found == 1) {
            class_2561 teleportButtonPopup = class_2564.method_10885((class_2561)new class_2588("chat.coordinates", new Object[]{spawnPos.get(0), spawnPos.get(1), spawnPos.get(2)})).method_10859(style_1x -> style_1x.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/tp @s " + spawnPos.get(0) + " " + spawnPos.get(1) + " " + spawnPos.get(2))).method_10949(new class_2568(class_2568.class_2569.field_11762, (class_2561)new class_2588("chat.coordinates.tooltip", new Object[0]))));
            source.method_9226((class_2561)new class_2588("commands.locate.success", new Object[]{new class_2588(structureName, new Object[0]), teleportButtonPopup, Math.round(distance)}), false);
            return 1;
        }
        if (found == -1) {
            source.method_9211().method_3760().method_14616(new class_2585("Could not find that structure in this biome").method_10854(class_124.field_1061), false);
            return -1;
        }
        source.method_9211().method_3760().method_14616(new class_2585("The structure '" + structureName + "' is not a valid RAA structure").method_10854(class_124.field_1061), false);
        return -1;
    }

    private static SuggestionProvider<class_2168> suggestedStrings() {
        return (ctx, builder) -> CommandLocateRAAStructure.getSuggestionsBuilder(builder, STRUCTURES);
    }

    private static CompletableFuture<Suggestions> getSuggestionsBuilder(SuggestionsBuilder builder, List<String> list) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (list.isEmpty()) {
            return Suggestions.empty();
        }
        for (String str : list) {
            if (!str.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    private static boolean isRaaDimension(class_2168 source) {
        String dim = source.method_9225().method_8597().method_12460().method_12489();
        return !dim.equals("") && !dim.equals("_end") && !dim.equals("_nether");
    }
}

