/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.vampirestudios.raa.config.RAADataConfig;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.registries.Dimensions;
import io.github.vampirestudios.raa.utils.GsonUtils;
import io.github.vampirestudios.raa.utils.Utils;
import java.io.FileWriter;
import java.util.Arrays;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class DimensionsConfig
extends RAADataConfig {
    public DimensionsConfig(String fileName) {
        super(fileName);
    }

    @Override
    public void generate() {
        Dimensions.generate();
    }

    @Override
    protected JsonObject upgrade(JsonObject json, int version) {
        JsonArray dimensions = class_3518.method_15261((JsonObject)json, (String)"dimensions");
        switch (version) {
            case 0: {
                break;
            }
            case 1: {
                DimensionsConfig.iterateArrayObjects(dimensions, dimension -> {
                    if (!class_3518.method_15286((JsonElement)dimension.get("id"))) {
                        dimension.addProperty("id", GsonUtils.idFromOldStyle(dimension.getAsJsonObject("id")).toString());
                    }
                    if (dimension.has("dimensionColorPallet")) {
                        dimension.add("dimensionColorPalette", (JsonElement)dimension.getAsJsonObject("dimensionColorPallet"));
                    }
                    dimension.add("hasSkyLight", dimension.get("hasLight"));
                    JsonObject biomeData = dimension.getAsJsonObject("biomeData");
                    if (!class_3518.method_15286((JsonElement)biomeData.get("id"))) {
                        biomeData.addProperty("id", GsonUtils.idFromOldStyle(biomeData.getAsJsonObject("id")).toString());
                    }
                    if (!dimension.has("dimensionChunkGenerator")) {
                        dimension.addProperty("dimensionChunkGenerator", Utils.randomCG(100).name());
                    }
                });
            }
        }
        return json;
    }

    @Override
    protected void load(JsonObject jsonObject) {
        DimensionData[] dimensionsData = (DimensionData[])GsonUtils.getGson().fromJson((JsonElement)class_3518.method_15261((JsonObject)jsonObject, (String)"dimensions"), DimensionData[].class);
        Arrays.stream(dimensionsData).forEach(dimensionData -> {
            DimensionData cfr_ignored_0 = (DimensionData)class_2378.method_10230(Dimensions.DIMENSIONS, (class_2960)dimensionData.getId(), (Object)dimensionData);
        });
    }

    @Override
    protected void save(FileWriter fileWriter) {
        JsonObject main = new JsonObject();
        main.add("dimensions", GsonUtils.getGson().toJsonTree(Dimensions.DIMENSIONS.method_10220().toArray(DimensionData[]::new)));
        main.addProperty("configVersion", (Number)2);
        GsonUtils.getGson().toJson((JsonElement)main, (Appendable)fileWriter);
    }
}

